/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Map;
import java.util.PrimitiveIterator;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_7225;
import org.cyclops.cyclopscore.datastructure.WrappedIntIterator;
import org.cyclops.cyclopscore.inventory.LargeInventoryCommon;

public class IndexedInventoryCommon
extends LargeInventoryCommon {
    private final Map<class_1792, Int2ObjectMap<class_1799>> index = Maps.newIdentityHashMap();
    private IntSet emptySlots = new IntAVLTreeSet();
    private IntSet nonEmptySlots = new IntAVLTreeSet();

    public IndexedInventoryCommon() {
        this(0, 0);
    }

    public IndexedInventoryCommon(int size, int stackLimit) {
        super(size, stackLimit);
        this.createIndex();
    }

    protected void createIndex() {
        this.index.clear();
        this.nonEmptySlots.clear();
        this.emptySlots.clear();
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 itemStack = this.method_5438(i);
            if (!itemStack.method_7960()) {
                Int2ObjectOpenHashMap stacks = this.index.get(itemStack.method_7909());
                if (stacks == null) {
                    stacks = new Int2ObjectOpenHashMap();
                    this.index.put(itemStack.method_7909(), (Int2ObjectMap<class_1799>)stacks);
                }
                stacks.put(i, (Object)itemStack);
                this.nonEmptySlots.add(i);
                continue;
            }
            this.emptySlots.add(i);
        }
    }

    @Override
    public void readFromNBT(class_7225.class_7874 provider, class_2487 data, String tag) {
        super.readFromNBT(provider, data, tag);
        this.createIndex();
    }

    @Override
    public void method_5447(int slotId, class_1799 itemStack) {
        Int2ObjectMap<class_1799> stacks;
        class_1799 oldStack = this.method_5438(slotId);
        boolean wasEmpty = oldStack.method_7960();
        boolean isEmpty = itemStack.method_7960();
        if (!oldStack.method_7960()) {
            stacks = this.index.get(oldStack.method_7909());
            if (stacks != null) {
                stacks.remove(slotId);
            }
            if (stacks.isEmpty()) {
                this.index.remove(oldStack.method_7909());
            }
        }
        if (!itemStack.method_7960()) {
            stacks = this.index.get(itemStack.method_7909());
            if (stacks == null) {
                stacks = new Int2ObjectOpenHashMap();
                this.index.put(itemStack.method_7909(), stacks);
            }
            stacks.put(slotId, (Object)itemStack);
        }
        super.method_5447(slotId, itemStack);
        if (wasEmpty && !isEmpty) {
            this.emptySlots.remove(slotId);
            this.nonEmptySlots.add(slotId);
        }
        if (!wasEmpty && isEmpty) {
            this.emptySlots.add(slotId);
            this.nonEmptySlots.remove(slotId);
        }
        if (this.nonEmptySlots.size() + this.emptySlots.size() != this.method_5439()) {
            throw new IllegalStateException(String.format("Indexed inventory at inconsistent state %s %s %s (slot: %s).", this.nonEmptySlots, this.emptySlots, this.method_5439(), slotId));
        }
    }

    @Override
    public void method_5448() {
        super.method_5448();
        this.index.clear();
    }

    public int getInventoryReferenceStackLimit() {
        return this.method_5444();
    }

    public Map<class_1792, Int2ObjectMap<class_1799>> getIndex() {
        return this.index;
    }

    public PrimitiveIterator.OfInt getEmptySlots() {
        return new WrappedIntIterator(this.emptySlots.iterator());
    }

    public PrimitiveIterator.OfInt getNonEmptySlots() {
        return new WrappedIntIterator(this.nonEmptySlots.iterator());
    }
}

