/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network.packet;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.CyclopsCore;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.network.packet.PlayerPositionPacket;

public class RingOfFirePacket
extends PlayerPositionPacket {
    private static final double RING_AREA = (double)0.9f;

    public RingOfFirePacket() {
    }

    public RingOfFirePacket(Player player) {
        super(player);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void showFireRing(Level world, Vec3 pos) {
        double area = 0.9f;
        int points = 40;
        for (double point = (double)(-points); point <= (double)points; point += 1.0) {
            double u = Math.PI * 2 * (point / (double)points);
            double xOffset = Math.cos(u) * area;
            double yOffset = 0.0;
            double zOffset = Math.sin(u) * area;
            double x = pos.f_82479_;
            double y = pos.f_82480_;
            double z = pos.f_82481_;
            double particleX = x + xOffset + (double)(world.f_46441_.m_188501_() / 5.0f);
            double particleY = y + yOffset + (double)(world.f_46441_.m_188501_() / 5.0f);
            double particleZ = z + zOffset + (double)(world.f_46441_.m_188501_() / 5.0f);
            float particleMotionX = (float)xOffset / 50.0f;
            float particleMotionY = 0.01f;
            float particleMotionZ = (float)zOffset / 50.0f;
            if (world.f_46441_.m_188503_(20) == 0) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123756_, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
                continue;
            }
            world.m_7106_((ParticleOptions)ParticleTypes.f_123744_, particleX, particleY, particleZ, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ);
        }
    }

    @Override
    protected PlayerPositionPacket create(Player player, int range) {
        return new RingOfFirePacket(player);
    }

    @Override
    protected ModBase getModInstance() {
        return CyclopsCore._instance;
    }

    @Override
    protected void performClientAction(Level level, Player player) {
        RingOfFirePacket.showFireRing(level, this.position);
    }
}

