/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.persist.world;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.persist.nbt.INBTProvider;
import org.cyclops.cyclopscore.persist.nbt.NBTProviderComponent;

public abstract class WorldStorage
implements INBTProvider {
    protected final ModBase mod;
    private INBTProvider nbtProviderComponent = new NBTProviderComponent(this);

    public WorldStorage(ModBase mod) {
        this.mod = mod;
    }

    public void readFromNBT(CompoundTag tag) {
        this.readGeneratedFieldsFromNBT(tag);
    }

    public void writeToNBT(CompoundTag tag) {
        this.writeGeneratedFieldsToNBT(tag);
    }

    public abstract void reset();

    public void onAboutToStartEvent(ServerAboutToStartEvent event) {
        this.reset();
    }

    public void onStartedEvent(ServerStartedEvent event) {
        this.reset();
        this.initDataHolder(event.getServer());
        this.afterLoad();
    }

    public void onStoppingEvent(ServerStoppingEvent event) {
        this.beforeSave();
        this.initDataHolder(event.getServer());
    }

    protected abstract String getDataId();

    private NBTDataHolder initDataHolder(MinecraftServer server) {
        return (NBTDataHolder)server.m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> NBTDataHolder.load(e, this), () -> new NBTDataHolder(this), this.mod.getModId() + "_" + this.getDataId());
    }

    public void afterLoad() {
    }

    public void beforeSave() {
    }

    @Override
    public void writeGeneratedFieldsToNBT(CompoundTag tag) {
        this.nbtProviderComponent.writeGeneratedFieldsToNBT(tag);
    }

    @Override
    public void readGeneratedFieldsFromNBT(CompoundTag tag) {
        this.nbtProviderComponent.readGeneratedFieldsFromNBT(tag);
    }

    public static class NBTDataHolder
    extends SavedData {
        private final WorldStorage parentStorage;

        public NBTDataHolder(WorldStorage parentStorage) {
            this.parentStorage = parentStorage;
        }

        public static NBTDataHolder load(CompoundTag tag, WorldStorage parentStorage) {
            NBTDataHolder dataHolder = new NBTDataHolder(parentStorage);
            dataHolder.parentStorage.readFromNBT(tag);
            return dataHolder;
        }

        public CompoundTag m_7176_(CompoundTag tag) {
            this.parentStorage.writeToNBT(tag);
            return tag;
        }

        public boolean m_77764_() {
            return true;
        }
    }
}

