/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.gametest;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiConsumer;
import net.minecraft.class_10660;
import net.minecraft.class_10664;
import net.minecraft.class_10665;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.cyclops.cyclopscore.gametest.GameTest;
import org.cyclops.cyclopscore.gametest.MethodGameTestInstance;

public class GameTestLoaderHelpers {
    public static boolean areGameTestsEnabled(String modId) {
        return System.getProperty("neoforge.enabledGameTestNamespaces", "").contains(modId) || System.getProperty("cyclopsmc.enabledGameTestNamespaces", "").contains(modId);
    }

    public static void registerCommonTests(String modId, Class<?>[] testClasses, BiConsumer<class_2960, class_10660> registrar, class_2378<class_10665> testEnvironmentRegistry) {
        for (MethodGameTestInstance testInstance : GameTestLoaderHelpers.generateCommonTests(modId, testClasses, testEnvironmentRegistry)) {
            registrar.accept(testInstance.getId(), testInstance);
        }
    }

    public static Collection<MethodGameTestInstance> generateCommonTests(String modId, Class<?>[] testClasses, class_2378<class_10665> testEnvironmentRegistry) {
        ArrayList testsList = Lists.newArrayList();
        for (Class<?> clazz : testClasses) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(GameTest.class)) continue;
                GameTest gameTest = method.getAnnotation(GameTest.class);
                class_6880.class_6883 environment = testEnvironmentRegistry.method_46747(class_5321.method_29179((class_5321)class_7924.field_56160, (class_2960)class_2960.method_60654((String)gameTest.environment())));
                testsList.add(new MethodGameTestInstance((class_10664<class_6880<class_10665>>)new class_10664((Object)environment, class_2960.method_60654((String)gameTest.template()), gameTest.timeoutTicks(), gameTest.setupTicks(), gameTest.required(), gameTest.rotation(), gameTest.manualOnly(), gameTest.attempts(), gameTest.requiredSuccesses(), gameTest.skyAccess()), modId, clazz.getName(), method.getName()));
            }
        }
        return testsList;
    }
}

