/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.cyclops.cyclopscore.helper.IItemStackHelpers;
import org.cyclops.cyclopscore.inventory.PlayerExtendedInventoryIterator;

public abstract class ItemStackHelpersCommon
implements IItemStackHelpers {
    private static final Random RANDOM = new Random();

    @Override
    public void spawnItemStack(class_1937 world, class_2338 pos, class_1799 itemStack) {
        this.spawnItemStack(world, pos.method_10263(), pos.method_10264(), pos.method_10260(), itemStack);
    }

    @Override
    public void spawnItemStack(class_1937 world, double x, double y, double z, class_1799 itemStack) {
        float offsetX = RANDOM.nextFloat() * 0.8f + 0.1f;
        float offsetY = RANDOM.nextFloat() * 0.8f + 0.1f;
        float offsetZ = RANDOM.nextFloat() * 0.8f + 0.1f;
        while (itemStack.method_7947() > 0) {
            int i = RANDOM.nextInt(21) + 10;
            if (i > itemStack.method_7947()) {
                i = itemStack.method_7947();
            }
            class_1799 dropStack = itemStack.method_7972();
            itemStack.method_7934(i);
            dropStack.method_7939(i);
            class_1542 entityitem = new class_1542(world, x + (double)offsetX, y + (double)offsetY, z + (double)offsetZ, dropStack);
            float motion = 0.05f;
            entityitem.method_18800(RANDOM.nextGaussian() * (double)motion, RANDOM.nextGaussian() * (double)motion + 0.2, RANDOM.nextGaussian() * (double)motion);
            world.method_8649((class_1297)entityitem);
        }
    }

    @Override
    public void spawnItemStackToPlayer(class_1937 world, class_2338 pos, class_1799 stack, class_1657 player) {
        if (!world.method_8608()) {
            float f = 0.5f;
            double xo = (double)(world.field_9229.method_43057() * f) + (double)(1.0f - f) * 0.5;
            double yo = (double)(world.field_9229.method_43057() * f) + (double)(1.0f - f) * 0.5;
            double zo = (double)(world.field_9229.method_43057() * f) + (double)(1.0f - f) * 0.5;
            class_1542 entityitem = new class_1542(world, (double)pos.method_10263() + xo, (double)pos.method_10264() + yo, (double)pos.method_10260() + zo, stack);
            double d0 = 8.0;
            double d1 = (player.method_23317() - entityitem.method_23317()) / d0;
            double d2 = (player.method_23318() + (double)player.method_5751() - entityitem.method_23318()) / d0;
            double d3 = (player.method_23321() - entityitem.method_23321()) / d0;
            entityitem.method_18799(entityitem.method_18798().method_1031(d1, d2, d3));
            entityitem.method_6975();
            world.method_8649((class_1297)entityitem);
        }
    }

    @Override
    public boolean hasPlayerItem(class_1657 player, class_1792 item) {
        PlayerExtendedInventoryIterator it = new PlayerExtendedInventoryIterator(player);
        while (it.hasNext()) {
            class_1799 itemStack = it.next();
            if (itemStack == null || itemStack.method_7909() != item) continue;
            return true;
        }
        return false;
    }

    @Override
    public class_1799 parseItemStack(String itemStackString) {
        String[] split = itemStackString.split(":");
        String itemName = split[0] + ":" + split[1];
        class_1792 item = (class_1792)class_7923.field_41178.method_63535(class_2960.method_60654((String)itemName));
        if (item == null) {
            throw new IllegalArgumentException("Invalid ItemStack item: " + itemName);
        }
        int amount = 1;
        if (split.length > 2) {
            try {
                amount = Integer.parseInt(split[2]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid ItemStack amount: " + split[2]);
            }
        }
        return new class_1799((class_1935)item, amount);
    }

    @Override
    public int getItemStackHashCode(class_1799 stack) {
        if (stack.method_7960()) {
            return class_1799.field_8037.hashCode();
        }
        int result = 1;
        result = 37 * result + stack.method_7947();
        result = 37 * result + stack.method_7909().hashCode();
        return result;
    }
}

