/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory.container;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_2487;
import net.minecraft.class_7225;
import net.minecraft.class_8942;
import org.cyclops.cyclopscore.inventory.container.ContainerExtended;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;
import org.slf4j.Logger;

public class SyncedGuiVariable<T>
implements Supplier<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ContainerExtended gui;
    private final int guiValueId;
    private final NBTClassType<T> nbtClassType;
    private final Supplier<T> serverValueSupplier;
    private final class_7225.class_7874 holderLookupProvider;
    private class_2487 lastTag;

    SyncedGuiVariable(ContainerExtended gui, Class<T> clazz, Supplier<T> serverValueSupplier, class_7225.class_7874 holderLookupProvider) {
        this.gui = gui;
        this.guiValueId = gui.getNextValueId();
        this.nbtClassType = NBTClassType.getClassType(clazz);
        this.serverValueSupplier = serverValueSupplier;
        this.holderLookupProvider = holderLookupProvider;
        this.lastTag = null;
    }

    public void detectAndSendChanges() {
        T value = this.serverValueSupplier.get();
        try (class_8942.class_11340 problemReporter = new class_8942.class_11340(this.gui.player.method_71370(), LOGGER);){
            class_11362 tagValueOutput = class_11362.method_71459((class_8942)problemReporter, (class_7225.class_7874)this.holderLookupProvider);
            this.nbtClassType.writePersistedField("v", value, (class_11372)tagValueOutput);
            class_2487 tag = tagValueOutput.method_71475();
            if (!Objects.equals(this.lastTag, tag)) {
                this.gui.setValue(this.guiValueId, tag);
                this.lastTag = tag;
            }
        }
    }

    @Override
    public T get() {
        class_2487 tag = this.gui.getValue(this.guiValueId);
        if (tag == null || !tag.method_10545("v")) {
            return this.nbtClassType.getDefaultValue();
        }
        try (class_8942.class_11340 problemreporter$scopedcollector = new class_8942.class_11340(LOGGER);){
            class_11368 input = class_11352.method_71417((class_8942)problemreporter$scopedcollector.method_54946(this.gui.player.method_71370()), (class_7225.class_7874)this.holderLookupProvider, (class_2487)tag);
            T t = this.nbtClassType.readPersistedField("v", input);
            return t;
        }
    }
}

