/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_10938;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_9129;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.joml.Vector3d;

public class PacketCodecs {
    public static final int READ_STRING_MAX_LENGTH = Short.MAX_VALUE;
    private static Map<Class<?>, PacketCodec.ICodecAction> codecActions = Maps.newHashMap();

    public static void addCodedAction(Class<?> clazz, PacketCodec.ICodecAction action) {
        codecActions.put(clazz, action);
    }

    @Nullable
    public static PacketCodec.ICodecAction getActionSuper(Class<?> clazz) {
        PacketCodec.ICodecAction action;
        if (ClassUtils.isPrimitiveWrapper(clazz)) {
            clazz = ClassUtils.wrapperToPrimitive(clazz);
        }
        if ((action = codecActions.get(clazz)) == null) {
            for (Class<?> iface : clazz.getInterfaces()) {
                action = codecActions.get(iface);
                if (action == null) continue;
                return action;
            }
            Class superClass = clazz.getSuperclass();
            if (superClass != null) {
                return PacketCodecs.getActionSuper(superClass);
            }
            return null;
        }
        return action;
    }

    public static PacketCodec.ICodecAction getAction(Class<?> clazz) {
        PacketCodec.ICodecAction action = PacketCodecs.getActionSuper(clazz);
        if (action == null) {
            System.err.println("No ICodecAction was found for " + String.valueOf(clazz) + ". You should add one in PacketCodec.");
        }
        return action;
    }

    public static void write(class_9129 packetBuffer, Object object) {
        PacketCodec.ICodecAction action = Objects.requireNonNull(PacketCodecs.getActionSuper(object.getClass()), "No codec action was registered for " + object.getClass().getName());
        action.encode(object, packetBuffer);
    }

    public static <T> T read(class_9129 packetBuffer, Class<T> clazz) {
        PacketCodec.ICodecAction action = Objects.requireNonNull(PacketCodecs.getActionSuper(clazz));
        return (T)action.decode(packetBuffer);
    }

    static {
        codecActions.put(String.class, new PacketCodec.ICodecAction(){

            @Override
            public void encode(Object object, class_9129 output) {
                output.method_10814((String)object);
            }

            @Override
            public Object decode(class_9129 input) {
                return input.method_10800(Short.MAX_VALUE);
            }
        });
        codecActions.put(Double.TYPE, new PacketCodec.ICodecAction(){

            @Override
            public void encode(Object object, class_9129 output) {
                output.method_52940(((Double)object).doubleValue());
            }

            @Override
            public Object decode(class_9129 input) {
                return input.readDouble();
            }
        });
        codecActions.put(Integer.TYPE, new PacketCodec.ICodecAction(){

            @Override
            public void encode(Object object, class_9129 output) {
                output.method_53002(((Integer)object).intValue());
            }

            @Override
            public Object decode(class_9129 input) {
                return input.readInt();
            }
        });
        codecActions.put(Long.TYPE, new PacketCodec.ICodecAction(){

            @Override
            public void encode(Object object, class_9129 output) {
                output.method_52974(((Long)object).longValue());
            }

            @Override
            public Object decode(class_9129 input) {
                return input.readLong();
            }
        });
        codecActions.put(Short.TYPE, new PacketCodec.ICodecAction(){

            @Override
            public void encode(Object object, class_9129 output) {
                output.method_52998((int)((Short)object).shortValue());
            }

            @Override
            public Object decode(class_9129 input) {
                return input.readShort();
            }
        });
        codecActions.put(Boolean.TYPE, new PacketCodec.ICodecAction(){

            @Override
            public void encode(Object object, class_9129 output) {
                output.method_52964(((Boolean)object).booleanValue());
            }

            @Override
            public Object decode(class_9129 input) {
                return input.readBoolean();
            }
        });
        codecActions.put(Float.TYPE, new PacketCodec.ICodecAction(){

            @Override
            public void encode(Object object, class_9129 output) {
                output.method_52941(((Float)object).floatValue());
            }

            @Override
            public Object decode(class_9129 input) {
                return Float.valueOf(input.readFloat());
            }
        });
        codecActions.put(Vector3d.class, new PacketCodec.ICodecAction(){

            @Override
            public void encode(Object object, class_9129 output) {
                Vector3d v = (Vector3d)object;
                output.method_52940(v.x);
                output.method_52940(v.y);
                output.method_52940(v.z);
            }

            @Override
            public Object decode(class_9129 input) {
                double x = input.readDouble();
                double y = input.readDouble();
                double z = input.readDouble();
                return new Vector3d(x, y, z);
            }
        });
        codecActions.put(class_2382.class, new PacketCodec.ICodecAction(){

            @Override
            public void encode(Object object, class_9129 output) {
                class_2382 v = (class_2382)object;
                output.method_53002(v.method_10263());
                output.method_53002(v.method_10264());
                output.method_53002(v.method_10260());
            }

            @Override
            public Object decode(class_9129 input) {
                int x = input.readInt();
                int y = input.readInt();
                int z = input.readInt();
                return new class_2382(x, y, z);
            }
        });
        codecActions.put(class_243.class, new PacketCodec.ICodecAction(){

            @Override
            public void encode(Object object, class_9129 output) {
                class_243 v = (class_243)object;
                output.method_52940(v.field_1352);
                output.method_52940(v.field_1351);
                output.method_52940(v.field_1350);
            }

            @Override
            public Object decode(class_9129 input) {
                double x = input.readDouble();
                double y = input.readDouble();
                double z = input.readDouble();
                return new class_243(x, y, z);
            }
        });
        codecActions.put(Map.class, new PacketCodec.ICodecAction(){

            @Override
            public void encode(Object object, class_9129 output) {
                Map map = (Map)object;
                output.method_53002(map.size());
                Set entries = map.entrySet();
                PacketCodec.ICodecAction keyAction = null;
                PacketCodec.ICodecAction valueAction = null;
                for (Map.Entry entry : entries) {
                    if (keyAction == null) {
                        keyAction = PacketCodecs.getAction(entry.getKey().getClass());
                        output.method_10814(entry.getKey().getClass().getName());
                    }
                    if (valueAction == null) {
                        valueAction = PacketCodecs.getAction(entry.getValue().getClass());
                        output.method_10814(entry.getValue().getClass().getName());
                    }
                    keyAction.encode(entry.getKey(), output);
                    valueAction.encode(entry.getValue(), output);
                }
            }

            @Override
            public Object decode(class_9129 input) {
                HashMap map = Maps.newHashMap();
                int size = input.readInt();
                if (size == 0) {
                    return map;
                }
                try {
                    PacketCodec.ICodecAction keyAction = PacketCodecs.getAction(Class.forName(input.method_10800(Short.MAX_VALUE)));
                    PacketCodec.ICodecAction valueAction = PacketCodecs.getAction(Class.forName(input.method_10800(Short.MAX_VALUE)));
                    for (int i = 0; i < size; ++i) {
                        Object key = keyAction.decode(input);
                        Object value = valueAction.decode(input);
                        map.put(key, value);
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                return map;
            }
        });
        codecActions.put(class_2487.class, new PacketCodec.ICodecAction(){

            @Override
            public void encode(Object object, class_9129 output) {
                output.method_10794((class_2520)((class_2487)object));
            }

            @Override
            public Object decode(class_9129 input) {
                return input.method_10798();
            }
        });
        codecActions.put(class_2520.class, new PacketCodec.ICodecAction(){

            @Override
            public void encode(Object object, class_9129 output) {
                class_2487 tag = new class_2487();
                tag.method_10566("v", (class_2520)object);
                output.method_10794((class_2520)tag);
            }

            @Override
            public Object decode(class_9129 input) {
                class_2487 tag = input.method_10798();
                return tag.method_10580("v");
            }
        });
        codecActions.put(class_1799.class, new PacketCodec.ICodecAction(){

            @Override
            public void encode(Object object, class_9129 output) {
                class_1799.field_49268.encode((Object)output, (Object)((class_1799)object));
            }

            @Override
            public Object decode(class_9129 input) {
                return class_1799.field_49268.decode((Object)input);
            }
        });
        codecActions.put(class_10938.class, new PacketCodec.ICodecAction(){

            @Override
            public void encode(Object object, class_9129 output) {
                class_10938.field_58177.encode((Object)output, (Object)((class_10938)object));
            }

            @Override
            public Object decode(class_9129 input) {
                return class_10938.field_58177.decode((Object)input);
            }
        });
        codecActions.put(class_2350.class, new PacketCodec.ICodecAction(){

            @Override
            public void encode(Object object, class_9129 output) {
                output.method_53002(((class_2350)object).ordinal());
            }

            @Override
            public Object decode(class_9129 input) {
                return class_2350.values()[input.readInt()];
            }
        });
        codecActions.put(class_2338.class, new PacketCodec.ICodecAction(){

            @Override
            public void encode(Object object, class_9129 output) {
                output.method_10807((class_2338)object);
            }

            @Override
            public Object decode(class_9129 input) {
                return input.method_10811();
            }
        });
        codecActions.put(class_5321.class, new PacketCodec.ICodecAction(){

            @Override
            public void encode(Object object, class_9129 output) {
                output.method_10814(((class_5321)object).method_41185().toString());
                output.method_10814(((class_5321)object).method_29177().toString());
            }

            @Override
            public Object decode(class_9129 input) {
                return class_5321.method_29179((class_5321)class_5321.method_29180((class_2960)class_2960.method_60654((String)input.method_10800(Short.MAX_VALUE))), (class_2960)class_2960.method_60654((String)input.method_10800(Short.MAX_VALUE)));
            }
        });
        codecActions.put(List.class, new PacketCodec.ICodecAction(){

            @Override
            public void encode(Object object, class_9129 output) {
                List list = (List)object;
                output.method_53002(list.size());
                if (list.size() == 0) {
                    return;
                }
                PacketCodec.ICodecAction valueAction = null;
                for (int i = 0; i < list.size(); ++i) {
                    Object value = list.get(i);
                    if (value == null) continue;
                    if (valueAction == null) {
                        valueAction = PacketCodecs.getAction(value.getClass());
                        output.method_10814(value.getClass().getName());
                    }
                    output.method_53002(i);
                    valueAction.encode(value, output);
                }
                if (valueAction == null) {
                    output.method_10814("__noclass");
                } else {
                    output.method_53002(-1);
                }
            }

            @Override
            public Object decode(class_9129 input) {
                int size = input.readInt();
                if (size == 0) {
                    return Collections.emptyList();
                }
                ArrayList list = Lists.newArrayListWithExpectedSize((int)size);
                try {
                    String className = input.method_10800(Short.MAX_VALUE);
                    if (!className.equals("__noclass")) {
                        int i;
                        PacketCodec.ICodecAction valueAction = PacketCodecs.getAction(Class.forName(className));
                        int currentLength = 0;
                        while ((i = input.readInt()) >= 0) {
                            while (currentLength < i) {
                                list.add(null);
                                ++currentLength;
                            }
                            Object value = valueAction.decode(input);
                            list.add(value);
                            ++currentLength;
                        }
                        while (currentLength < size) {
                            list.add(null);
                            ++currentLength;
                        }
                    } else {
                        for (int i = 0; i < size; ++i) {
                            list.add(null);
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                return list;
            }
        });
        codecActions.put(Pair.class, new PacketCodec.ICodecAction(){

            @Override
            public void encode(Object object, class_9129 output) {
                output.method_10814(((Pair)object).getLeft().getClass().getName());
                output.method_10814(((Pair)object).getRight().getClass().getName());
                PacketCodecs.write(output, ((Pair)object).getLeft());
                PacketCodecs.write(output, ((Pair)object).getRight());
            }

            @Override
            public Object decode(class_9129 input) {
                try {
                    PacketCodec.ICodecAction keyAction = PacketCodecs.getAction(Class.forName(input.method_10800(Short.MAX_VALUE)));
                    PacketCodec.ICodecAction valueAction = PacketCodecs.getAction(Class.forName(input.method_10800(Short.MAX_VALUE)));
                    Object key = keyAction.decode(input);
                    Object value = valueAction.decode(input);
                    return Pair.of((Object)key, (Object)value);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    return Pair.of(null, null);
                }
            }
        });
    }
}

