/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.persist.nbt;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Either;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_5699;
import net.minecraft.class_7923;
import net.minecraft.class_8824;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.cyclopscore.helper.CyclopsCoreInstance;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.persist.nbt.INBTProvider;
import org.cyclops.cyclopscore.persist.nbt.INBTSerializable;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;

public abstract class NBTClassType<T> {
    public static Map<Class<?>, NBTClassType<?>> NBTYPES = new IdentityHashMap();

    public static <T> NBTClassType<T> getClassType(Class<T> clazz) {
        return NBTYPES.get(clazz);
    }

    public static <T, I extends T> void writeNbt(Class<T> clazz, String name, I instance, class_11372 tag) {
        NBTClassType<I> serializationClass = NBTClassType.getClassType(clazz);
        if (serializationClass == null) {
            throw new RuntimeException("No valid NBT serialization was found for " + String.valueOf(instance) + " of type " + String.valueOf(clazz));
        }
        serializationClass.writePersistedField(name, instance, tag);
    }

    public static <T> T readNbt(Class<T> clazz, String name, class_11368 tag) {
        NBTClassType<T> serializationClass = NBTClassType.getClassType(clazz);
        if (serializationClass == null) {
            throw new RuntimeException("No valid NBT serialization was found type " + String.valueOf(clazz));
        }
        return serializationClass.readPersistedField(name, tag);
    }

    private static boolean isImplementsInterface(Class<?> clazz, Class<?> interfaceClazz) {
        return interfaceClazz.isAssignableFrom(clazz);
    }

    private static NBTClassType getTypeSilent(Class<?> type) {
        NBTClassType<?> action = NBTYPES.get(type);
        if (action == null) {
            for (Class<?> iface : type.getInterfaces()) {
                action = NBTYPES.get(iface);
                if (action == null) continue;
                return action;
            }
            Class<?> superClass = type.getSuperclass();
            if (superClass != null) {
                return NBTClassType.getTypeSilent(superClass);
            }
            return null;
        }
        return action;
    }

    public static NBTClassType getType(Class<?> type, Object target) {
        if (NBTClassType.isImplementsInterface(type, INBTSerializable.class)) {
            return new INBTSerializable.SelfNBTClassType(type);
        }
        NBTClassType action = NBTClassType.getTypeSilent(type);
        if (action == null) {
            throw new RuntimeException("No NBT persist action found for type " + type.getName() + " or any of its parents and interfaces in class " + String.valueOf(target.getClass()) + " for target object " + String.valueOf(target) + ".");
        }
        return action;
    }

    public static void performActionForField(INBTProvider provider, Field field, Either<class_11368, class_11372> tag) {
        Class<?> type = field.getType();
        String fieldName = field.getName();
        boolean wasAccessible = field.isAccessible();
        if (!wasAccessible) {
            field.setAccessible(true);
        }
        NBTClassType.getType(type, provider).persistedFieldAction(provider, field, tag);
    }

    public void persistedFieldAction(INBTProvider provider, Field field, Either<class_11368, class_11372> valueIo) {
        String name = field.getName();
        NBTPersist annotation = field.getAnnotation(NBTPersist.class);
        boolean useDefaultValue = annotation.useDefaultValue();
        Object castTile = field.getDeclaringClass().cast(provider);
        valueIo.ifRight(output -> {
            block5: {
                try {
                    field.setAccessible(true);
                    Object object = field.get(castTile);
                    if (object == null) break block5;
                    try {
                        this.writePersistedField(name, (T)object, (class_11372)output);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new RuntimeException("Something went from with the field " + field.getName() + " in " + String.valueOf(castTile) + ": " + e.getMessage());
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("Can not write the field " + field.getName() + " in " + String.valueOf(castTile) + " since it does not exist. " + e.getMessage());
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Can not write the field " + field.getName() + " in " + String.valueOf(castTile) + " since it can not be accessed. " + e.getMessage());
                }
            }
        });
        valueIo.ifLeft(input -> {
            Object object = null;
            try {
                try {
                    object = this.readPersistedField(name, (class_11368)input);
                    field.setAccessible(true);
                    field.set(castTile, object);
                }
                catch (NoSuchElementException error) {
                    if (useDefaultValue) {
                        object = this.getDefaultValue();
                        field.setAccessible(true);
                        field.set(castTile, object);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                throw new RuntimeException("Can not read the field " + field.getName() + " as " + String.valueOf(object) + " in " + String.valueOf(castTile) + " since it does not exist OR there is a class mismatch. " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                throw new RuntimeException("Can not read the field " + field.getName() + " as " + String.valueOf(object) + " in " + String.valueOf(castTile) + " since it can not be accessed. " + e.getMessage());
            }
        });
    }

    public abstract void writePersistedField(String var1, T var2, class_11372 var3);

    public abstract T readPersistedField(String var1, class_11368 var2);

    public abstract T getDefaultValue();

    static {
        NBTYPES.put(Integer.class, new NBTClassType<Integer>(){

            @Override
            public void writePersistedField(String name, Integer object, class_11372 tag) {
                tag.method_71465(name, object.intValue());
            }

            @Override
            public Integer readPersistedField(String name, class_11368 tag) {
                return (Integer)tag.method_71439(name).orElseThrow();
            }

            @Override
            public Integer getDefaultValue() {
                return 0;
            }
        });
        NBTYPES.put(Integer.TYPE, NBTYPES.get(Integer.class));
        NBTYPES.put(Float.class, new NBTClassType<Float>(){

            @Override
            public void writePersistedField(String name, Float object, class_11372 tag) {
                tag.method_71464(name, object.floatValue());
            }

            @Override
            public Float readPersistedField(String name, class_11368 tag) {
                return Float.valueOf(tag.method_71423(name, 0.0f));
            }

            @Override
            public Float getDefaultValue() {
                return Float.valueOf(0.0f);
            }
        });
        NBTYPES.put(Float.TYPE, NBTYPES.get(Float.class));
        NBTYPES.put(Boolean.class, new NBTClassType<Boolean>(){

            @Override
            public void writePersistedField(String name, Boolean object, class_11372 tag) {
                tag.method_71472(name, object.booleanValue());
            }

            @Override
            public Boolean readPersistedField(String name, class_11368 tag) {
                return tag.method_71433(name, false);
            }

            @Override
            public Boolean getDefaultValue() {
                return false;
            }
        });
        NBTYPES.put(Boolean.TYPE, NBTYPES.get(Boolean.class));
        NBTYPES.put(String.class, new NBTClassType<String>(){

            @Override
            public void writePersistedField(String name, String object, class_11372 tag) {
                if (object != null && !object.isEmpty()) {
                    tag.method_71469(name, object);
                }
            }

            @Override
            public String readPersistedField(String name, class_11368 tag) {
                return (String)tag.method_71441(name).orElseThrow();
            }

            @Override
            public String getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(class_2350.class, new NBTClassType<class_2350>(){

            @Override
            public void writePersistedField(String name, class_2350 object, class_11372 tag) {
                tag.method_71465(name, object.ordinal());
            }

            @Override
            public class_2350 readPersistedField(String name, class_11368 tag) {
                return class_2350.values()[(Integer)tag.method_71439(name).orElseThrow()];
            }

            @Override
            public class_2350 getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(class_3611.class, new NBTClassType<class_3611>(){

            @Override
            public void writePersistedField(String name, class_3611 object, class_11372 tag) {
                tag.method_71469(name, class_7923.field_41173.method_10221((Object)object).toString());
            }

            @Override
            public class_3611 readPersistedField(String name, class_11368 tag) {
                String fluidName = (String)tag.method_71441(name).orElseThrow();
                return (class_3611)class_7923.field_41173.method_63535(class_2960.method_60654((String)fluidName));
            }

            @Override
            public class_3611 getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(class_2520.class, new NBTClassType<class_2520>(){

            @Override
            public void writePersistedField(String name, class_2520 object, class_11372 tag) {
                tag.method_71468(name, class_5699.field_60980, (Object)object);
            }

            @Override
            public class_2520 readPersistedField(String name, class_11368 tag) {
                return (class_2520)tag.method_71426(name, class_5699.field_60980).orElseThrow();
            }

            @Override
            public class_2520 getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(Set.class, new CollectionNBTClassType<Set>(){

            @Override
            protected Set createNewCollection() {
                return Sets.newHashSet();
            }
        });
        NBTYPES.put(List.class, new CollectionNBTClassType<List>(){

            @Override
            protected List createNewCollection() {
                return Lists.newLinkedList();
            }
        });
        NBTYPES.put(Map.class, new NBTClassType<Map>(){

            @Override
            public void writePersistedField(String name, Map object, class_11372 tag) {
                class_11372 mapTag = tag.method_71461(name);
                class_11372.class_11374 list = mapTag.method_71476("map");
                boolean setKeyType = false;
                boolean setValueType = false;
                for (Map.Entry entry : object.entrySet()) {
                    class_11372 entryTag = list.method_71480();
                    10.getType(entry.getKey().getClass(), object).writePersistedField("k", entry.getKey(), entryTag);
                    if (entry.getValue() != null) {
                        10.getType(entry.getValue().getClass(), object).writePersistedField("v", entry.getValue(), entryTag.method_71461("v"));
                    }
                    if (!setKeyType) {
                        setKeyType = true;
                        mapTag.method_71469("keyType", entry.getKey().getClass().getName());
                    }
                    if (setValueType || entry.getValue() == null) continue;
                    setValueType = true;
                    mapTag.method_71469("valueType", entry.getValue().getClass().getName());
                }
            }

            @Override
            public Map readPersistedField(String name, class_11368 tag) {
                class_11368 mapTag = (class_11368)tag.method_71420(name).orElseThrow();
                HashMap map = Maps.newHashMap();
                class_11368.class_11370 list = (class_11368.class_11370)mapTag.method_71436("map").orElseThrow();
                if (!list.method_71444()) {
                    NBTClassType keyNBTClassType;
                    Wrapper valueNBTClassType = new Wrapper();
                    try {
                        Class<?> keyType = Class.forName((String)mapTag.method_71441("keyType").orElseThrow());
                        keyNBTClassType = 10.getType(keyType, map);
                    }
                    catch (ClassNotFoundException e) {
                        CyclopsCoreInstance.MOD.getLoggerHelper().log(Level.WARN, "No class found for NBT type map key '" + String.valueOf(mapTag.method_71441("keyType")) + "', this could be a mod error.");
                        return map;
                    }
                    mapTag.method_71441("valueType").ifPresent(valueTypeString -> {
                        try {
                            Class<?> valueType = Class.forName(valueTypeString);
                            valueNBTClassType.set(10.getType(valueType, map));
                        }
                        catch (ClassNotFoundException e) {
                            CyclopsCoreInstance.MOD.getLoggerHelper().log(Level.WARN, "No class found for NBT type map value '" + String.valueOf(mapTag.method_71441("valueType")) + "', this could be a mod error.");
                        }
                    });
                    for (class_11368 entryTag : list) {
                        Object key = keyNBTClassType.readPersistedField("k", entryTag);
                        Object value = null;
                        Optional entryTagChild = entryTag.method_71420("v");
                        if (valueNBTClassType != null && entryTagChild.isPresent()) {
                            value = ((NBTClassType)valueNBTClassType.get()).readPersistedField("v", (class_11368)entryTagChild.orElseThrow());
                        }
                        map.put(key, value);
                    }
                }
                return map;
            }

            @Override
            public Map getDefaultValue() {
                return Maps.newHashMap();
            }
        });
        NBTYPES.put(class_2382.class, new NBTClassType<class_2382>(){

            @Override
            public void writePersistedField(String name, class_2382 object, class_11372 tag) {
                tag.method_71473(name, new int[]{object.method_10263(), object.method_10264(), object.method_10260()});
            }

            @Override
            public class_2382 readPersistedField(String name, class_11368 tag) {
                int[] array = (int[])tag.method_71442(name).orElseThrow();
                return new class_2382(array[0], array[1], array[2]);
            }

            @Override
            public class_2382 getDefaultValue() {
                return IModHelpers.get().getLocationHelpers().copyLocation(class_2382.field_11176);
            }
        });
        NBTYPES.put(class_243.class, new NBTClassType<class_243>(){

            @Override
            public void writePersistedField(String name, class_243 object, class_11372 tag) {
                class_11372 vec = tag.method_71461(name);
                vec.method_71463("x", object.field_1352);
                vec.method_71463("y", object.field_1351);
                vec.method_71463("z", object.field_1350);
            }

            @Override
            public class_243 readPersistedField(String name, class_11368 tag) {
                class_11368 vec = (class_11368)tag.method_71420(name).orElseThrow();
                return new class_243(vec.method_71422("x", 0.0), vec.method_71422("y", 0.0), vec.method_71422("z", 0.0));
            }

            @Override
            public class_243 getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(Pair.class, new NBTClassType<Pair>(){

            @Override
            public void writePersistedField(String name, Pair object, class_11372 tag) {
                class_11372 pairTag = tag.method_71461(name);
                class_11372 leftTag = pairTag.method_71461("left");
                class_11372 rightTag = pairTag.method_71461("right");
                13.getType(object.getLeft().getClass(), object).writePersistedField("element", object.getLeft(), leftTag);
                13.getType(object.getRight().getClass(), object).writePersistedField("element", object.getRight(), rightTag);
                pairTag.method_71469("leftType", object.getLeft().getClass().getName());
                pairTag.method_71469("rightType", object.getRight().getClass().getName());
            }

            @Override
            public Pair readPersistedField(String name, class_11368 tag) {
                NBTClassType rightElementNBTClassType;
                NBTClassType leftElementNBTClassType;
                class_11368 pairTag = (class_11368)tag.method_71420(name).orElseThrow();
                class_11368 leftTag = (class_11368)pairTag.method_71420("left").orElseThrow();
                class_11368 rightTag = (class_11368)pairTag.method_71420("right").orElseThrow();
                try {
                    Class<?> elementType = Class.forName((String)pairTag.method_71441("leftType").orElseThrow());
                    leftElementNBTClassType = 13.getType(elementType, Pair.class);
                }
                catch (ClassNotFoundException e) {
                    CyclopsCoreInstance.MOD.getLoggerHelper().log(Level.WARN, "No class found for NBT type Pair left element '" + String.valueOf(pairTag.method_71441("leftType")) + "', this could be a mod error.");
                    return Pair.of(null, null);
                }
                try {
                    Class<?> elementType = Class.forName((String)pairTag.method_71441("rightType").orElseThrow());
                    rightElementNBTClassType = 13.getType(elementType, Pair.class);
                }
                catch (ClassNotFoundException e) {
                    CyclopsCoreInstance.MOD.getLoggerHelper().log(Level.WARN, "No class found for NBT type Pair right element '" + String.valueOf(pairTag.method_71441("rightType")) + "', this could be a mod error.");
                    return Pair.of(null, null);
                }
                Object left = leftElementNBTClassType.readPersistedField("element", leftTag);
                Object right = rightElementNBTClassType.readPersistedField("element", rightTag);
                return Pair.of(left, right);
            }

            @Override
            public Pair getDefaultValue() {
                return Pair.of(null, null);
            }
        });
        NBTYPES.put(class_1799.class, new NBTClassType<class_1799>(){

            @Override
            public void writePersistedField(String name, class_1799 object, class_11372 tag) {
                if (object != null) {
                    tag.method_71468(name, class_1799.field_49266, (Object)object);
                }
            }

            @Override
            public class_1799 readPersistedField(String name, class_11368 tag) {
                return (class_1799)tag.method_71426(name, class_1799.field_49266).orElseThrow();
            }

            @Override
            public class_1799 getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(class_2561.class, new NBTClassType<class_2561>(){

            @Override
            public void writePersistedField(String name, class_2561 object, class_11372 tag) {
                if (object != null) {
                    tag.method_71468(name, class_8824.field_46597, (Object)object);
                }
            }

            @Override
            public class_2561 readPersistedField(String name, class_11368 tag) {
                return (class_2561)tag.method_71426(name, class_8824.field_46597).orElseThrow();
            }

            @Override
            public class_2561 getDefaultValue() {
                return null;
            }
        });
        NBTYPES.put(EnumFacingMap.class, new NBTClassType<EnumFacingMap>(){

            @Override
            public void writePersistedField(String name, EnumFacingMap object, class_11372 tag) {
                class_11372 mapTag = tag.method_71461(name);
                class_11372.class_11374 list = mapTag.method_71476("map");
                boolean setValueType = false;
                for (Map.Entry entry : object.entrySet()) {
                    class_11372 entryTag = list.method_71480();
                    entryTag.method_71465("k", ((class_2350)entry.getKey()).ordinal());
                    if (entry.getValue() != null) {
                        16.getType(entry.getValue().getClass(), object).writePersistedField("v", entry.getValue(), entryTag.method_71461("v"));
                    }
                    if (setValueType || entry.getValue() == null) continue;
                    setValueType = true;
                    mapTag.method_71469("valueType", entry.getValue().getClass().getName());
                }
            }

            @Override
            public EnumFacingMap readPersistedField(String name, class_11368 tag) {
                class_11368 mapTag = (class_11368)tag.method_71420(name).orElseThrow();
                EnumFacingMap<Object> map = EnumFacingMap.newMap();
                class_11368.class_11370 list = (class_11368.class_11370)mapTag.method_71436("map").orElseThrow();
                if (!list.method_71444()) {
                    Wrapper valueNBTClassType = new Wrapper();
                    mapTag.method_71441("valueType").ifPresent(valueTypeString -> {
                        try {
                            Class<?> valueType = Class.forName(valueTypeString);
                            valueNBTClassType.set(16.getType(valueType, map));
                        }
                        catch (ClassNotFoundException e) {
                            CyclopsCoreInstance.MOD.getLoggerHelper().log(Level.WARN, "No class found for NBT type map value '" + String.valueOf(mapTag.method_71441("valueType")) + "', this could be a mod error.");
                        }
                    });
                    for (class_11368 entryTag : list) {
                        class_2350 key = class_2350.values()[(Integer)entryTag.method_71439("k").orElseThrow()];
                        Object value = null;
                        Optional entryTagChild = entryTag.method_71420("v");
                        if (valueNBTClassType != null && entryTagChild.isPresent()) {
                            value = ((NBTClassType)valueNBTClassType.get()).readPersistedField("v", (class_11368)entryTagChild.orElseThrow());
                        }
                        map.put(key, value);
                    }
                }
                return map;
            }

            @Override
            public EnumFacingMap getDefaultValue() {
                return EnumFacingMap.newMap();
            }
        });
    }

    private static abstract class CollectionNBTClassType<C extends Collection>
    extends NBTClassType<C> {
        private CollectionNBTClassType() {
        }

        protected abstract C createNewCollection();

        @Override
        public C getDefaultValue() {
            return this.createNewCollection();
        }

        @Override
        public void writePersistedField(String name, C object, class_11372 tag) {
            class_11372 collectionTag = tag.method_71461(name);
            class_11372.class_11374 list = collectionTag.method_71476("collection");
            boolean setTypes = false;
            for (Object element : object) {
                class_11372 elementTag = list.method_71480();
                CollectionNBTClassType.getType(element.getClass(), object).writePersistedField("element", element, elementTag);
                if (setTypes) continue;
                setTypes = true;
                collectionTag.method_71469("elementType", element.getClass().getName());
            }
        }

        @Override
        public C readPersistedField(String name, class_11368 tag) {
            class_11368 collectionTag = (class_11368)tag.method_71420(name).orElseThrow();
            C collection = this.createNewCollection();
            class_11368.class_11370 list = (class_11368.class_11370)collectionTag.method_71436("collection").orElseThrow();
            if (!list.method_71444()) {
                NBTClassType elementNBTClassType;
                try {
                    Class<?> elementType = Class.forName((String)collectionTag.method_71441("elementType").orElseThrow());
                    elementNBTClassType = CollectionNBTClassType.getType(elementType, collection);
                }
                catch (ClassNotFoundException e) {
                    CyclopsCoreInstance.MOD.getLoggerHelper().log(Level.WARN, "No class found for NBT type collection element '" + String.valueOf(collectionTag.method_71441("elementType")) + "', this could be a mod error.");
                    return collection;
                }
                for (class_11368 entryTag : list) {
                    collection.add(elementNBTClassType.readPersistedField("element", entryTag));
                }
            }
            return collection;
        }
    }
}

