/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.ConfigHandlerCommon;
import org.cyclops.cyclopscore.config.ConfigurablePropertyData;
import org.cyclops.cyclopscore.config.IConfigInitializer;
import org.cyclops.cyclopscore.config.ModConfigLocation;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfigCommon;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfigRegistry;
import org.cyclops.cyclopscore.config.extendedconfig.FluidConfigForge;
import org.cyclops.cyclopscore.init.ModBaseForge;

public class ConfigHandlerForge
extends ConfigHandlerCommon {
    private final Multimap<String, Pair<ExtendedConfigRegistry<?, ?, ?>, Callable<?>>> registryEntriesHolder = Multimaps.newListMultimap((Map)Maps.newHashMap(), (Supplier)new Supplier<List<Pair<ExtendedConfigRegistry<?, ?, ?>, Callable<?>>>>(this){

        public List<Pair<ExtendedConfigRegistry<?, ?, ?>, Callable<?>>> get() {
            return Lists.newArrayList();
        }
    });
    private Set<String> registryEventPassed = Sets.newHashSet();

    public ConfigHandlerForge(ModBaseForge<?> mod) {
        super(mod);
        mod.getModBusGroup().register(MethodHandles.lookup(), (Object)this);
    }

    public Multimap<String, Pair<ExtendedConfigRegistry<?, ?, ?>, Callable<?>>> getRegistryEntriesHolder() {
        return this.registryEntriesHolder;
    }

    public Set<String> getRegistryEventPassed() {
        return this.registryEventPassed;
    }

    @Override
    public <V> void registerToRegistry(Registry<? super V> registry, ExtendedConfigRegistry<?, V, ?> config, @Nullable Callable<?> callback) {
        if (this.registryEventPassed.contains(registry.key().toString())) {
            throw new IllegalStateException(String.format("Tried registering %s after its registration event.", config.getNamedId()));
        }
        this.registryEntriesHolder.put((Object)registry.key().toString(), (Object)Pair.of(config, callback));
    }

    @SubscribeEvent
    public void onLoad(ModConfigEvent.Loading configEvent) {
        this.getMod().log(Level.TRACE, "Load config");
        this.syncProcessedConfigs(configEvent.getConfig(), false);
    }

    @SubscribeEvent
    public void onReload(ModConfigEvent.Reloading configEvent) {
        this.getMod().log(Level.TRACE, "Reload config");
        this.syncProcessedConfigs(configEvent.getConfig(), true);
    }

    @SubscribeEvent
    public void onRegistryEvent(RegisterEvent event) {
        this.registryEventPassed.add(event.getRegistryKey().toString());
        this.registryEntriesHolder.get((Object)event.getRegistryKey().toString()).forEach(pair -> {
            ExtendedConfigRegistry config = (ExtendedConfigRegistry)pair.getLeft();
            event.register(event.getRegistryKey(), ConfigHandlerForge.getConfigId(config), (java.util.function.Supplier)((Supplier)config::getInstance));
            try {
                if (pair.getRight() != null) {
                    ((Callable)pair.getRight()).call();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void initialize(Collection<IConfigInitializer> configInitializers) {
        EnumMap<ModConfig.Type, ForgeConfigSpec.Builder> configBuilders = new EnumMap<ModConfig.Type, ForgeConfigSpec.Builder>(ModConfig.Type.class);
        for (ExtendedConfigCommon extendedConfigCommon : this.getConfigurables()) {
            ForgeConfigSpec.Builder configBuilder = (ForgeConfigSpec.Builder)configBuilders.get(ModConfig.Type.COMMON);
            if (configBuilder == null) {
                configBuilder = new ForgeConfigSpec.Builder();
                configBuilders.put(ModConfig.Type.COMMON, configBuilder);
            }
            this.addCategory(extendedConfigCommon.getConfigurableType().getCategory());
            for (ConfigurablePropertyData<?> configProperty : extendedConfigCommon.configProperties.values()) {
                ForgeConfigSpec.Builder configBuilderProperty = (ForgeConfigSpec.Builder)configBuilders.get(ConfigHandlerForge.modConfigLocationToType(configProperty.getConfigLocation()));
                if (configBuilderProperty == null) {
                    configBuilderProperty = new ForgeConfigSpec.Builder();
                    configBuilders.put(ConfigHandlerForge.modConfigLocationToType(configProperty.getConfigLocation()), configBuilderProperty);
                }
                this.getCategories().add(configProperty.getCategory());
                this.onConfigPropertyInit(configProperty, configBuilder);
                if (!configProperty.isCommandable()) continue;
                this.getCommandableProperties().put(configProperty.getName(), configProperty);
            }
        }
        for (IConfigInitializer iConfigInitializer : configInitializers) {
            iConfigInitializer.initializeConfig(configBuilders);
        }
        for (Map.Entry entry : configBuilders.entrySet()) {
            ((ModBaseForge)this.getMod()).getModLoadingContext().registerConfig((ModConfig.Type)entry.getKey(), (IConfigSpec)((ForgeConfigSpec.Builder)entry.getValue()).build());
        }
    }

    protected <T> void onConfigPropertyInit(ConfigurablePropertyData<T> configPropertyData, ForgeConfigSpec.Builder configBuilder) {
        configBuilder.push(configPropertyData.category);
        if (configPropertyData.requiresWorldRestart) {
            configBuilder.worldRestart();
        }
        ForgeConfigSpec.ConfigValue configProperty = configBuilder.comment(configPropertyData.comment).translation(configPropertyData.getLanguageKey()).define(configPropertyData.name, configPropertyData.defaultValue);
        configPropertyData.setConfigProperty((java.util.function.Supplier<Object>)configProperty, newValue -> {
            configProperty.set(newValue);
            configProperty.save();
        });
        configBuilder.pop();
    }

    public void syncProcessedConfigs(ModConfig config, boolean reload) {
        for (ExtendedConfigCommon extendedConfigCommon : this.getConfigurables()) {
            for (ConfigurablePropertyData<?> configProperty : extendedConfigCommon.configProperties.values()) {
                configProperty.saveToField();
                extendedConfigCommon.onConfigPropertyReload(configProperty, reload);
            }
        }
    }

    public static ModConfig.Type modConfigLocationToType(ModConfigLocation modConfigLocation) {
        switch (modConfigLocation) {
            case COMMON: {
                return ModConfig.Type.COMMON;
            }
            case CLIENT: {
                return ModConfig.Type.CLIENT;
            }
            case SERVER: {
                return ModConfig.Type.SERVER;
            }
            case STARTUP: {
                throw new UnsupportedOperationException("Startup is not supported yet.");
            }
        }
        return null;
    }

    @Override
    public void addToConfigDictionary(ExtendedConfigCommon<?, ?, ?> e) {
        super.addToConfigDictionary(e);
        if (e instanceof FluidConfigForge) {
            this.getConfigDictionary().put(e.getNamedId(), e);
        }
    }
}

