/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.Arrays;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import org.cyclops.cyclopscore.helper.IL10NHelpers;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.StringHelpers;

public class L10NHelpersCommon
implements IL10NHelpers {
    private static final String KEY_ENABLED = "general.cyclopscore.info.enabled";
    private static final String KEY_DISABLED = "general.cyclopscore.info.disabled";
    private final IModHelpers modHelpers;

    public L10NHelpersCommon(IModHelpers modHelpers) {
        this.modHelpers = modHelpers;
    }

    @Override
    public String localize(String key, Object ... params) {
        if (this.modHelpers.getMinecraftHelpers().isModdedEnvironment()) {
            return I18n.get((String)key, (Object[])params);
        }
        return String.format("%s: %s", key, Arrays.toString(params));
    }

    @Override
    public void addStatusInfo(Consumer<Component> tooltipAdder, boolean isEnabled, String statusPrefixKey) {
        MutableComponent autoSupply = Component.translatable((String)KEY_DISABLED);
        if (isEnabled) {
            autoSupply = Component.translatable((String)KEY_ENABLED);
        }
        tooltipAdder.accept((Component)Component.translatable((String)statusPrefixKey, (Object[])new Object[]{autoSupply}));
    }

    @Override
    public void addOptionalInfo(Consumer<Component> tooltipAdder, String prefix) {
        String key = prefix + ".info";
        if (I18n.exists((String)key)) {
            if (this.modHelpers.getMinecraftClientHelpers().isShifted()) {
                String localized = this.localize(key, new Object[0]);
                StringHelpers.splitLines(localized, this.getMaxTooltipLineLength(), this.getInfoPrefix()).stream().map(Component::literal).forEach(tooltipAdder);
            } else {
                tooltipAdder.accept((Component)Component.translatable((String)"general.cyclopscore.tooltip.info").setStyle(Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GRAY)).withItalic(Boolean.valueOf(true))));
            }
        }
    }
}

