/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory.container;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.client.gui.component.WidgetScrollBar;
import org.cyclops.cyclopscore.inventory.container.InventoryContainer;

public abstract class ScrollingInventoryContainer<E>
extends InventoryContainer
implements WidgetScrollBar.IScrollCallback {
    private final List<E> unfilteredItems;
    private List<Pair<Integer, E>> filteredItems;
    private final List<E> visibleItems;
    private final IItemPredicate<E> itemSearchPredicate;
    private String lastSearchString = "";
    private int firstElement = 0;

    public ScrollingInventoryContainer(@Nullable MenuType<?> type, int id, Inventory playerInventory, Container inventory, List<E> items, IItemPredicate<E> filterer) {
        super(type, id, playerInventory, inventory);
        this.unfilteredItems = Lists.newArrayList(items);
        this.filteredItems = Lists.newLinkedList();
        this.visibleItems = Arrays.asList(new Object[this.getPageSize() * this.getColumns()]);
        for (int i = 0; i < this.getPageSize(); ++i) {
            this.visibleItems.set(i, null);
        }
        this.itemSearchPredicate = filterer;
    }

    protected List<E> getUnfilteredItems() {
        return this.unfilteredItems;
    }

    protected List<Pair<Integer, E>> getFilteredItems() {
        return this.filteredItems;
    }

    public int getUnfilteredItemCount() {
        return this.getUnfilteredItems().size();
    }

    public int getFilteredItemCount() {
        return this.getFilteredItems().size();
    }

    public int getFirstElement() {
        return this.firstElement;
    }

    public int getColumns() {
        return 1;
    }

    public int getScrollStepSize() {
        return this.getColumns();
    }

    @Override
    public void onScroll(int firstRow) {
        this.firstElement = firstRow * this.getScrollStepSize();
        if (this.firstElement < 0) {
            this.firstElement = 0;
        }
        for (int i = 0; i < this.getPageSize(); ++i) {
            for (int j = 0; j < this.getColumns(); ++j) {
                int index = i * this.getColumns() + j;
                int elementIndex = index + this.firstElement;
                this.visibleItems.set(index, null);
                if (elementIndex >= this.getFilteredItemCount()) continue;
                Pair<Integer, E> filteredItem = this.getFilteredItems().get(elementIndex);
                this.enableElementAt(index, (Integer)filteredItem.getLeft(), filteredItem.getRight());
            }
        }
    }

    public abstract int getPageSize();

    protected void enableElementAt(int visibleIndex, int elementIndex, E element) {
        this.visibleItems.set(visibleIndex, element);
    }

    public boolean isElementVisible(int row) {
        return row < this.getPageSize() && this.getVisibleElement(row) != null;
    }

    public E getVisibleElement(int row) {
        if (row >= this.visibleItems.size()) {
            return null;
        }
        return this.visibleItems.get(row);
    }

    public void refreshFilter() {
        this.updateFilter(this.lastSearchString);
    }

    public void updateFilter(String searchString) {
        Pattern pattern;
        this.lastSearchString = searchString;
        try {
            pattern = Pattern.compile(".*" + searchString.toLowerCase() + ".*");
        }
        catch (PatternSyntaxException e) {
            pattern = Pattern.compile(".*");
        }
        this.filteredItems = this.filter(this.getUnfilteredItems(), this.itemSearchPredicate, pattern);
        this.onScroll(0);
    }

    protected List<Pair<Integer, E>> filter(List<E> input, IItemPredicate<E> predicate, Pattern pattern) {
        LinkedList filtered = Lists.newLinkedList();
        int i = 0;
        for (E item : input) {
            if (predicate.apply(item, pattern) && this.additionalApplies(item)) {
                filtered.add(Pair.of((Object)i, item));
            }
            ++i;
        }
        return filtered;
    }

    protected boolean additionalApplies(E item) {
        return true;
    }

    public static interface IItemPredicate<E> {
        public boolean apply(E var1, Pattern var2);
    }
}

