/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.IPacketCodecRunnable;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.network.PacketCodecs;

public abstract class PacketCodec<T extends PacketCodec<T>>
extends PacketBase<T> {
    protected SingleCache<Void, List<Field>> fieldCache = new SingleCache<Void, List<Field>>(new SingleCache.ICacheUpdater<Void, List<Field>>(){

        @Override
        public List<Field> getNewValue(Void key) {
            LinkedList fieldList = Lists.newLinkedList();
            for (Class<?> clazz = PacketCodec.this.getClass(); clazz != PacketCodec.class && clazz != null; clazz = clazz.getSuperclass()) {
                Field[] fields = clazz.getDeclaredFields();
                Arrays.sort(fields, new Comparator<Field>(this){

                    @Override
                    public int compare(Field o1, Field o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                for (Field field : fields) {
                    if (!field.isAnnotationPresent(CodecField.class)) continue;
                    fieldList.add(field);
                }
            }
            return fieldList;
        }

        @Override
        public boolean isKeyEqual(Void cacheKey, Void newKey) {
            return true;
        }
    });

    public PacketCodec(CustomPacketPayload.Type<T> type) {
        super(type);
    }

    private void loopCodecFields(IPacketCodecRunnable runnable) {
        for (Field field : this.fieldCache.get(null)) {
            Class<?> clazz = field.getType();
            ICodecAction action = PacketCodecs.getAction(clazz);
            boolean accessible = field.isAccessible();
            if (!accessible) {
                field.setAccessible(true);
            }
            runnable.run(field, action);
        }
    }

    @Override
    public void encode(RegistryFriendlyByteBuf output) {
        this.loopCodecFields((field, action) -> {
            Object object = null;
            try {
                object = field.get(this);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
            action.encode(object, output);
        });
    }

    @Override
    public void decode(RegistryFriendlyByteBuf input) {
        this.loopCodecFields((field, action) -> {
            Object object = action.decode(input);
            try {
                field.set(this, object);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        });
    }

    public static interface ICodecAction {
        public void encode(Object var1, RegistryFriendlyByteBuf var2);

        public Object decode(RegistryFriendlyByteBuf var1);
    }
}

