/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.ConfigurablePropertyCommon;
import org.cyclops.cyclopscore.config.ConfigurablePropertyData;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfigCommon;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfigCommon;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfigRegistry;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfigCommon;
import org.cyclops.cyclopscore.init.IModBase;

public abstract class ConfigHandlerCommon {
    private final IModBase mod;
    private final LinkedHashSet<ExtendedConfigCommon<?, ?, ?>> configurables = new LinkedHashSet();
    private final Map<String, ExtendedConfigCommon<?, ?, ?>> configDictionary = Maps.newHashMap();
    private final Set<String> categories = Sets.newHashSet();
    private final Map<String, ConfigurablePropertyData> commandableProperties = Maps.newHashMap();

    public ConfigHandlerCommon(IModBase mod) {
        this.mod = mod;
    }

    public IModBase getMod() {
        return this.mod;
    }

    public LinkedHashSet<ExtendedConfigCommon<?, ?, ?>> getConfigurables() {
        return this.configurables;
    }

    public Map<String, ExtendedConfigCommon<?, ?, ?>> getConfigDictionary() {
        return this.configDictionary;
    }

    public Set<String> getCategories() {
        return this.categories;
    }

    public Map<String, ConfigurablePropertyData> getCommandableProperties() {
        return this.commandableProperties;
    }

    public boolean addConfigurable(ExtendedConfigCommon<?, ?, ?> e) {
        this.addToConfigDictionary(e);
        return this.configurables.add(e);
    }

    public void addToConfigDictionary(ExtendedConfigCommon<?, ?, ?> e) {
        if (e instanceof BlockConfigCommon || e instanceof ItemConfigCommon) {
            this.configDictionary.put(e.getNamedId(), e);
        }
    }

    public void loadModInit() {
        for (ExtendedConfigCommon extendedConfigCommon : this.configurables) {
            this.mod.log(Level.TRACE, "Registering " + extendedConfigCommon.getNamedId());
            extendedConfigCommon.getConfigurableType().getConfigurableTypeAction().onRegisterModInit(extendedConfigCommon);
        }
    }

    public void loadForgeRegistries() {
        for (ExtendedConfigCommon extendedConfigCommon : this.configurables) {
            extendedConfigCommon.getConfigurableType().getConfigurableTypeAction().onRegisterForge(extendedConfigCommon);
        }
    }

    public void loadForgeRegistriesFilled() {
        for (ExtendedConfigCommon extendedConfigCommon : this.configurables) {
            extendedConfigCommon.getConfigurableType().getConfigurableTypeAction().onRegisterForgeFilled(extendedConfigCommon);
        }
    }

    public void loadSetup() {
        for (ExtendedConfigCommon extendedConfigCommon : this.configurables) {
            extendedConfigCommon.getConfigurableType().getConfigurableTypeAction().onRegisterSetup(extendedConfigCommon);
            extendedConfigCommon.onRegistered();
        }
    }

    public void addCategory(String category) {
        this.categories.add(category);
    }

    public Map<String, ExtendedConfigCommon<?, ?, ?>> getDictionary() {
        return this.configDictionary;
    }

    public abstract <V> void registerToRegistry(class_2378<? super V> var1, ExtendedConfigRegistry<?, V, ?> var2, @Nullable Callable<?> var3);

    public static class_2960 getConfigId(ExtendedConfigCommon<?, ?, ?> config) {
        return class_2960.method_60655((String)config.getMod().getModId(), (String)config.getNamedId());
    }

    public void generateConfigProperties(ExtendedConfigCommon<?, ?, ?> config) throws IllegalArgumentException, IllegalAccessException {
        for (Field field : ConfigHandlerCommon.getAllFields(config.getClass())) {
            if (!field.isAnnotationPresent(ConfigurablePropertyCommon.class)) continue;
            ConfigurablePropertyCommon annotation = field.getAnnotation(ConfigurablePropertyCommon.class);
            ConfigurablePropertyData<Object> configProperty = new ConfigurablePropertyData<Object>(this.getMod(), annotation.category(), config.getConfigPropertyPrefix(annotation) + "." + field.getName(), field.get(null), annotation.comment(), annotation.isCommandable(), annotation.configLocation(), field, annotation.requiresWorldRestart(), annotation.requiresMcRestart(), annotation.showInGui(), annotation.minimalValue(), annotation.maximalValue());
            config.configProperties.put(configProperty.getName(), configProperty);
        }
    }

    protected static List<Field> getAllFields(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            fields.addAll(Arrays.asList(c.getDeclaredFields()));
        }
        return fields;
    }
}

