/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import com.google.common.collect.Queues;
import java.util.Iterator;
import java.util.Queue;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.inventory.IInventoryCommonModifiable;
import org.cyclops.cyclopscore.inventory.IInventoryLocation;
import org.cyclops.cyclopscore.inventory.InventoryIterator;
import org.cyclops.cyclopscore.inventory.InventoryLocations;
import org.cyclops.cyclopscore.inventory.ItemLocation;

public class PlayerExtendedInventoryIterator
implements Iterator<class_1799> {
    private final Queue<Pair<IInventoryLocation, InventoryIterator>> iterators = Queues.newArrayDeque();

    public PlayerExtendedInventoryIterator(class_1657 player) {
        for (IInventoryLocation inventoryExtender : InventoryLocations.REGISTRY.values()) {
            IInventoryCommonModifiable inv = inventoryExtender.getInventory(player);
            if (inv == null) continue;
            this.iterators.add((Pair<IInventoryLocation, InventoryIterator>)Pair.of((Object)inventoryExtender, (Object)new InventoryIterator(inv)));
        }
    }

    @Override
    public boolean hasNext() {
        return this.iterators.size() > 0 && ((InventoryIterator)this.iterators.peek().getRight()).hasNext();
    }

    @Override
    public class_1799 next() {
        if (((InventoryIterator)this.iterators.peek().getRight()).hasNext()) {
            Pair<IInventoryLocation, InventoryIterator> extendedAndIterator = this.iterators.peek();
            Pair<Integer, class_1799> slotAndStack = ((InventoryIterator)extendedAndIterator.getRight()).nextIndexed();
            if (!((InventoryIterator)this.iterators.peek().getRight()).hasNext()) {
                this.iterators.poll();
            }
            return (class_1799)slotAndStack.getRight();
        }
        throw new IndexOutOfBoundsException();
    }

    public ItemLocation nextIndexed() {
        if (((InventoryIterator)this.iterators.peek().getRight()).hasNext()) {
            Pair<IInventoryLocation, InventoryIterator> extendedAndIterator = this.iterators.peek();
            Pair<Integer, class_1799> slotAndStack = ((InventoryIterator)extendedAndIterator.getRight()).nextIndexed();
            if (!((InventoryIterator)this.iterators.peek().getRight()).hasNext()) {
                this.iterators.poll();
            }
            return new ItemLocation((IInventoryLocation)extendedAndIterator.getLeft(), (Integer)slotAndStack.getLeft());
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented.");
    }

    public void replace(class_1799 itemStack) {
        ((InventoryIterator)this.iterators.peek().getRight()).replace(itemStack);
    }
}

