/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.component.button;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.util.ARGB;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonExtended;

public class ButtonText
extends ButtonExtended {
    private final Component text;

    public ButtonText(int x, int y, Component narrationMessage, Component text, Button.OnPress pressCallback) {
        this(x, y, Minecraft.getInstance().font.width(text.getVisualOrderText()) + 6, 16, narrationMessage, text, pressCallback, true);
    }

    public ButtonText(int x, int y, int width, int height, Component narrationMessage, Component text, Button.OnPress pressCallback, boolean background) {
        super(x, y, width, height, narrationMessage, pressCallback, background);
        this.text = text;
    }

    public Component getText() {
        return this.text;
    }

    @Override
    protected void drawButtonInner(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int color = ARGB.opaque((int)0xE0E0E0);
        if (!this.active) {
            color = ARGB.opaque((int)-6250336);
        } else if (this.isHoveredOrFocused()) {
            color = ARGB.opaque((int)0xFFFFA0);
        }
        guiGraphics.drawCenteredString(Minecraft.getInstance().font, this.getText(), this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, color);
    }
}

