/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.component.input;

import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonArrow;
import org.cyclops.cyclopscore.client.gui.component.input.IInputListener;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetTextFieldExtended;

public class WidgetArrowedListField<E>
extends WidgetTextFieldExtended {
    private final boolean arrows;
    private ButtonArrow arrowLeft;
    private ButtonArrow arrowRight;
    private List<E> elements;
    private int activeElement;
    private IInputListener listener;

    public WidgetArrowedListField(Font fontrenderer, int x, int y, int width, int height, boolean arrows, Component narrationMessage, boolean background, List<E> elements) {
        super(fontrenderer, x, y, width, height, narrationMessage, background);
        this.arrows = arrows;
        if (this.arrows) {
            this.arrowLeft = new ButtonArrow(x, y - 1, (Component)Component.translatable((String)"gui.cyclopscore.left"), button -> this.decrease(), ButtonArrow.Direction.WEST);
            this.arrowRight = new ButtonArrow(x + width, y - 1, (Component)Component.translatable((String)"gui.cyclopscore.right"), button -> this.increase(), ButtonArrow.Direction.EAST);
            this.arrowRight.setX(this.arrowRight.getX() - this.arrowRight.getWidth());
        }
        this.setBordered(true);
        this.elements = elements;
        this.setActiveElement(0);
    }

    @Override
    public void setListener(IInputListener listener) {
        this.listener = listener;
    }

    public boolean isBordered() {
        return false;
    }

    public void setActiveElement(int index) {
        if (index >= this.elements.size()) {
            this.activeElement = -1;
            this.setValue("");
        } else {
            this.activeElement = index;
            this.setValue(this.activeElementToString(this.getActiveElement()));
        }
        if (this.listener != null) {
            this.listener.onChanged();
        }
    }

    public boolean setActiveElement(E element) {
        int index = this.elements.indexOf(element);
        if (index < 0) {
            return false;
        }
        this.setActiveElement(index);
        return true;
    }

    protected String activeElementToString(E element) {
        return element.toString();
    }

    public E getActiveElement() throws NumberFormatException {
        if (this.activeElement < 0 || this.activeElement >= this.elements.size()) {
            return null;
        }
        return this.elements.get(this.activeElement);
    }

    @Override
    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int offsetX = 0;
        if (this.arrows) {
            this.arrowLeft.render(guiGraphics, mouseX, mouseY, partialTicks);
            this.arrowRight.render(guiGraphics, mouseX, mouseY, partialTicks);
            offsetX = this.arrowLeft.getWidth();
            this.setX(this.getX() + offsetX + 1);
            this.width -= offsetX * 2;
        }
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.arrows) {
            this.setX(this.getX() - (offsetX + 1));
            this.width += offsetX * 2;
        }
    }

    protected void increase() {
        if (!this.elements.isEmpty()) {
            this.setActiveElement((this.activeElement + 1) % this.elements.size());
        }
    }

    protected void decrease() {
        if (!this.elements.isEmpty()) {
            this.setActiveElement((this.activeElement - 1 + this.elements.size()) % this.elements.size());
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return this.arrowLeft.mouseClicked(mouseX, mouseY, mouseButton) || this.arrowRight.mouseClicked(mouseX, mouseY, mouseButton) || super.mouseClicked(mouseX, mouseY, mouseButton);
    }
}

