/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.fluid;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class TankForge
extends FluidTank {
    public TankForge(int capacity) {
        super(capacity);
    }

    public boolean isEmpty() {
        return this.getFluid().isEmpty() || this.getFluid().getAmount() <= 0;
    }

    public boolean isFull() {
        return !this.getFluid().isEmpty() && this.getFluid().getAmount() >= this.getCapacity();
    }

    public Fluid getFluidType() {
        return !this.getFluid().isEmpty() ? this.getFluid().getFluid() : null;
    }

    protected boolean replaceInnerFluid() {
        return true;
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        if (this.replaceInnerFluid()) {
            super.writeToNBT(nbt);
        }
        this.writeTankToNBT(nbt);
        return nbt;
    }

    public CompoundTag writeToNBT(CompoundTag nbt, String tag) {
        CompoundTag subTag = new CompoundTag();
        this.writeToNBT(subTag);
        nbt.put(tag, (Tag)subTag);
        return nbt;
    }

    public FluidTank readFromNBT(CompoundTag nbt) {
        if (this.replaceInnerFluid()) {
            if (nbt.contains("Empty")) {
                this.setFluid(null);
            }
            super.readFromNBT(nbt);
        }
        this.readTankFromNBT(nbt);
        return this;
    }

    public FluidTank readFromNBT(CompoundTag data, String tag) {
        CompoundTag subTag = (CompoundTag)data.getCompound(tag).orElseThrow();
        return this.readFromNBT(subTag);
    }

    public void writeTankToNBT(CompoundTag nbt) {
        nbt.putInt("capacity", this.getCapacity());
    }

    public void readTankFromNBT(CompoundTag nbt) {
        this.setCapacity((Integer)nbt.getInt("capacity").orElseThrow());
    }

    public int getTankCapacity(int tank) {
        if (tank == 0) {
            return this.getCapacity();
        }
        return 0;
    }
}

