/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.cyclops.cyclopscore.inventory.SimpleInventory;

public class LargeInventory
extends SimpleInventory {
    public LargeInventory() {
        this(0, 0);
    }

    public LargeInventory(int size, int stackLimit) {
        super(size, stackLimit);
    }

    @Override
    public void readFromNBT(ValueInput data, String tag) {
        ValueInput.ValueInputList nbttaglist = (ValueInput.ValueInputList)data.childrenList(tag).orElseThrow();
        for (int j = 0; j < this.getContainerSize(); ++j) {
            this.contents[j] = ItemStack.EMPTY;
        }
        for (ValueInput slot : nbttaglist) {
            int index = slot.getIntOr("Slot", 0);
            if (index < 0 || index >= this.getContainerSize()) continue;
            this.contents[index] = slot.read("Item", ItemStack.OPTIONAL_CODEC).orElse(ItemStack.EMPTY);
        }
    }

    @Override
    public void writeToNBT(ValueOutput data, String tag) {
        ValueOutput.ValueOutputList slots = data.childrenList(tag);
        for (int index = 0; index < this.getContainerSize(); ++index) {
            ItemStack itemStack = this.getItem(index);
            if (itemStack.isEmpty() || itemStack.getCount() <= 0) continue;
            ValueOutput slot = slots.addChild();
            slot.putInt("Slot", index);
            slot.store("Item", ItemStack.OPTIONAL_CODEC, (Object)itemStack);
        }
    }
}

