/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory.container;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.cyclops.cyclopscore.inventory.container.ContainerExtended;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;
import org.slf4j.Logger;

public class SyncedGuiVariable<T>
implements Supplier<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ContainerExtended gui;
    private final int guiValueId;
    private final NBTClassType<T> nbtClassType;
    private final Supplier<T> serverValueSupplier;
    private final HolderLookup.Provider holderLookupProvider;
    private CompoundTag lastTag;

    SyncedGuiVariable(ContainerExtended gui, Class<T> clazz, Supplier<T> serverValueSupplier, HolderLookup.Provider holderLookupProvider) {
        this.gui = gui;
        this.guiValueId = gui.getNextValueId();
        this.nbtClassType = NBTClassType.getClassType(clazz);
        this.serverValueSupplier = serverValueSupplier;
        this.holderLookupProvider = holderLookupProvider;
        this.lastTag = null;
    }

    public void detectAndSendChanges() {
        T value = this.serverValueSupplier.get();
        try (ProblemReporter.ScopedCollector problemReporter = new ProblemReporter.ScopedCollector(this.gui.player.problemPath(), LOGGER);){
            TagValueOutput tagValueOutput = TagValueOutput.createWithContext((ProblemReporter)problemReporter, (HolderLookup.Provider)this.holderLookupProvider);
            this.nbtClassType.writePersistedField("v", value, (ValueOutput)tagValueOutput);
            CompoundTag tag = tagValueOutput.buildResult();
            if (!Objects.equals(this.lastTag, tag)) {
                this.gui.setValue(this.guiValueId, tag);
                this.lastTag = tag;
            }
        }
    }

    @Override
    public T get() {
        CompoundTag tag = this.gui.getValue(this.guiValueId);
        if (tag == null || !tag.contains("v")) {
            return this.nbtClassType.getDefaultValue();
        }
        try (ProblemReporter.ScopedCollector problemreporter$scopedcollector = new ProblemReporter.ScopedCollector(LOGGER);){
            ValueInput input = TagValueInput.create((ProblemReporter)problemreporter$scopedcollector.forChild(this.gui.player.problemPath()), (HolderLookup.Provider)this.holderLookupProvider, (CompoundTag)tag);
            T t = this.nbtClassType.readPersistedField("v", input);
            return t;
        }
    }
}

