/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.persist.nbt;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;

public interface INBTSerializable {
    public void toValueOutput(ValueOutput var1);

    public void fromValueInput(ValueInput var1);

    public static class SelfNBTClassType
    extends NBTClassType<INBTSerializable> {
        private final Class<?> fieldType;

        public SelfNBTClassType(Class<?> fieldType) {
            this.fieldType = fieldType;
        }

        public Class<?> getFieldType() {
            return this.fieldType;
        }

        @Override
        public void writePersistedField(String name, INBTSerializable object, ValueOutput tag) {
            try {
                Method method = this.fieldType.getMethod("toValueOutput", ValueOutput.class);
                method.invoke((Object)object, tag);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("No method toValueOutput for field " + name + " of class " + String.valueOf(this.fieldType) + " was found.");
            }
            catch (InvocationTargetException e) {
                e.getTargetException().printStackTrace();
                throw new RuntimeException("Error in toValueOutput for field " + name + ". Error: " + e.getTargetException().getMessage());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Could invoke toValueOutput for " + name + ".");
            }
        }

        @Override
        public INBTSerializable readPersistedField(String name, ValueInput tag) {
            try {
                Constructor<?> constructor = this.fieldType.getConstructor(new Class[0]);
                if (constructor == null) {
                    throw new RuntimeException("The NBT serializable " + name + " of class " + String.valueOf(this.fieldType) + " must have a constructor without parameters.");
                }
                Method method = this.fieldType.getMethod("fromValueInput", ValueInput.class);
                INBTSerializable obj = (INBTSerializable)constructor.newInstance(new Object[0]);
                tag.child(name).ifPresentOrElse(child -> {
                    try {
                        method.invoke((Object)obj, child);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException("Could invoke fromValueInput for " + name + ".");
                    }
                    catch (InvocationTargetException e) {
                        e.getTargetException().printStackTrace();
                        throw new RuntimeException("Error in fromValueInput for field " + name + ". Error: " + e.getTargetException().getMessage());
                    }
                }, () -> System.out.println(String.format("The tag %s did not contain the key %s, skipping reading.", tag, name)));
                return obj;
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("No method fromValueInput for field " + name + " of class " + String.valueOf(this.fieldType) + " was found.");
            }
            catch (InvocationTargetException e) {
                e.getTargetException().printStackTrace();
                throw new RuntimeException("Error in fromValueInput for field " + name + ". Error: " + e.getTargetException().getMessage());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Could invoke fromValueInput for " + name + ".");
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                throw new RuntimeException("Something went wrong while calling the empty constructor for " + name + "of class " + String.valueOf(this.fieldType) + ".");
            }
        }

        @Override
        public INBTSerializable getDefaultValue() {
            return null;
        }
    }
}

