/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.ICraftingHelpers;
import org.cyclops.cyclopscore.helper.IModHelpers;

public class CraftingHelpersCommon
implements ICraftingHelpers {
    private final IModHelpers modHelpers;
    private final LoadingCache<Triple<RecipeType<?>, CacheableCraftingInventory, ResourceLocation>, Optional<RecipeHolder<? extends Recipe>>> CACHE_RECIPES = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build(new CacheLoader<Triple<RecipeType<?>, CacheableCraftingInventory, ResourceLocation>, Optional<RecipeHolder<? extends Recipe>>>(){

        public Optional<RecipeHolder<? extends Recipe>> load(Triple<RecipeType<?>, CacheableCraftingInventory, ResourceLocation> key) throws Exception {
            ServerLevel world = CraftingHelpersCommon.this.modHelpers.getMinecraftHelpers().getCurrentServer().getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)((ResourceLocation)key.getRight())));
            return world.getRecipeManager().getRecipeFor((RecipeType)key.getLeft(), ((CacheableCraftingInventory)key.getMiddle()).getInventoryCrafting(), (Level)world);
        }
    });

    public CraftingHelpersCommon(IModHelpers modHelpers) {
        this.modHelpers = modHelpers;
    }

    @Override
    public <C extends RecipeInput, T extends Recipe<C>> List<RecipeHolder<T>> findRecipes(Level world, RecipeType<? extends T> recipeType) {
        return world.isClientSide() ? this.getClientRecipes(recipeType) : this.findServerRecipes((ServerLevel)world, recipeType);
    }

    @Override
    public RecipeManager getRecipeManager() {
        return this.modHelpers.getMinecraftHelpers().isClientSide() ? Minecraft.getInstance().getConnection().getRecipeManager() : Objects.requireNonNull(this.modHelpers.getMinecraftHelpers().getCurrentServer().getLevel(Level.OVERWORLD), "Server is still loading").getRecipeManager();
    }

    @Override
    public <C extends RecipeInput, T extends Recipe<C>> Optional<RecipeHolder<T>> getServerRecipe(RecipeType<T> recipeType, ResourceLocation recipeName) {
        return Optional.ofNullable(this.getRecipeManager().byKeyTyped(recipeType, recipeName));
    }

    @Override
    public <C extends RecipeInput, T extends Recipe<C>> Optional<RecipeHolder<T>> findServerRecipe(RecipeType<T> recipeType, C container, Level world) {
        return world.getRecipeManager().getRecipeFor(recipeType, container, world);
    }

    @Override
    public <C extends RecipeInput, T extends Recipe<C>> List<RecipeHolder<T>> findServerRecipes(RecipeType<? extends T> recipeType) {
        return this.findServerRecipes(Objects.requireNonNull(this.modHelpers.getMinecraftHelpers().getCurrentServer().getLevel(Level.OVERWORLD)), recipeType);
    }

    @Override
    public <C extends RecipeInput, T extends Recipe<C>> List<RecipeHolder<T>> findServerRecipes(ServerLevel world, RecipeType<? extends T> recipeType) {
        return world.getRecipeManager().getAllRecipesFor(recipeType);
    }

    @Override
    public <C extends RecipeInput, T extends Recipe<C>> Optional<RecipeHolder<T>> getClientRecipe(RecipeType<T> recipeType, ResourceLocation recipeName) {
        return Optional.ofNullable(this.getRecipeManager().byKeyTyped(recipeType, recipeName));
    }

    @Override
    public <C extends RecipeInput, T extends Recipe<C>> List<RecipeHolder<T>> getClientRecipes(RecipeType<? extends T> recipeType) {
        return this.getRecipeManager().getAllRecipesFor(recipeType);
    }

    @Override
    public <C extends RecipeInput, T extends Recipe<C>> RecipeHolder<T> findClientRecipe(RegistryAccess registryAccess, ItemStack itemStack, RecipeType<T> recipeType, int index) throws IllegalArgumentException {
        int indexAttempt = index;
        for (RecipeHolder<T> recipe : this.getClientRecipes(recipeType)) {
            if (!ItemStack.isSameItemSameComponents((ItemStack)recipe.value().getResultItem((HolderLookup.Provider)registryAccess), (ItemStack)itemStack) || indexAttempt-- != 0) continue;
            return recipe;
        }
        throw new IllegalArgumentException("Could not find recipe for " + String.valueOf(itemStack) + "::" + String.valueOf(itemStack.getComponents()) + " with index " + index);
    }

    @Override
    public <C extends RecipeInput, T extends Recipe<C>> Optional<RecipeHolder<T>> findRecipeCached(RecipeType<T> recipeType, C inventoryCrafting, Level world, boolean uniqueInventory) {
        return (Optional)this.CACHE_RECIPES.getUnchecked((Object)Triple.of(recipeType, (Object)new CacheableCraftingInventory(inventoryCrafting, !uniqueInventory), (Object)world.dimension().location()));
    }

    public class CacheableCraftingInventory {
        private final RecipeInput inventoryCrafting;

        public CacheableCraftingInventory(RecipeInput inventoryCrafting, boolean copyInventory) {
            if (copyInventory) {
                int width = inventoryCrafting.size();
                int height = 1;
                if (inventoryCrafting instanceof CraftingInput) {
                    width = ((CraftingInput)inventoryCrafting).width();
                    height = ((CraftingInput)inventoryCrafting).height();
                }
                int size = inventoryCrafting.size();
                NonNullList items = NonNullList.withSize((int)size, (Object)ItemStack.EMPTY);
                for (int i = 0; i < inventoryCrafting.size(); ++i) {
                    items.set(i, (Object)inventoryCrafting.getItem(i).copy());
                }
                this.inventoryCrafting = CraftingInput.of((int)width, (int)height, (List)items);
            } else {
                this.inventoryCrafting = inventoryCrafting;
            }
        }

        public RecipeInput getInventoryCrafting() {
            return this.inventoryCrafting;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (!(obj instanceof CacheableCraftingInventory)) {
                return false;
            }
            RecipeInput otherInput = ((CacheableCraftingInventory)obj).getInventoryCrafting();
            RecipeInput recipeInput = this.getInventoryCrafting();
            if (recipeInput instanceof CraftingInput) {
                CraftingInput craftingInputThis = (CraftingInput)recipeInput;
                if (!(otherInput instanceof CraftingInput)) return false;
                CraftingInput craftingInputOther = (CraftingInput)otherInput;
                if (craftingInputThis.width() != craftingInputOther.width() || craftingInputThis.height() != craftingInputOther.height()) {
                    return false;
                }
            } else if (this.getInventoryCrafting().size() != otherInput.size()) {
                return false;
            }
            for (int i = 0; i < this.getInventoryCrafting().size(); ++i) {
                if (ItemStack.isSameItemSameComponents((ItemStack)this.getInventoryCrafting().getItem(i), (ItemStack)otherInput.getItem(i))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int hash = 11 + this.getInventoryCrafting().size();
            RecipeInput recipeInput = this.getInventoryCrafting();
            if (recipeInput instanceof CraftingInput) {
                CraftingInput craftingInput = (CraftingInput)recipeInput;
                hash = 23 + 3 * craftingInput.width() + 5 * craftingInput.height();
            }
            for (int i = 0; i < this.getInventoryCrafting().size(); ++i) {
                hash |= CraftingHelpersCommon.this.modHelpers.getItemStackHelpers().getItemStackHashCode(this.getInventoryCrafting().getItem(i)) * i;
            }
            return hash;
        }
    }
}

