/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory.container;

import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.cyclops.cyclopscore.inventory.InventoryLocationPlayer;
import org.cyclops.cyclopscore.inventory.ItemLocation;
import org.cyclops.cyclopscore.inventory.container.ContainerExtended;

public abstract class ItemInventoryContainer<I extends Item>
extends ContainerExtended {
    protected I item;
    protected ItemLocation itemLocation;

    public ItemInventoryContainer(@Nullable MenuType<?> type, int id, Inventory inventory, ItemLocation itemLocation) {
        super(type, id, inventory);
        this.item = itemLocation.getItemStack(inventory.f_35978_).m_41720_();
        this.itemLocation = itemLocation;
    }

    public static int readItemIndex(FriendlyByteBuf packetBuffer) {
        return packetBuffer.readInt();
    }

    public static InteractionHand readHand(FriendlyByteBuf packetBuffer) {
        return packetBuffer.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    public I getItem() {
        return this.item;
    }

    public boolean m_6875_(Player player) {
        ItemStack item = this.getItemStack(player);
        return item != null && item.m_41720_() == this.getItem();
    }

    public ItemStack getItemStack(Player player) {
        return this.itemLocation.getItemStack(player);
    }

    @Override
    protected Slot createNewSlot(Container inventory, int index, int x, int y) {
        return new Slot(inventory, index, x, y){

            public boolean m_8010_(Player player) {
                return this.m_7993_() != ItemInventoryContainer.this.itemLocation.getItemStack(player);
            }
        };
    }

    @Override
    public void m_150399_(int slotId, int arg, ClickType clickType, Player player) {
        if (clickType == ClickType.SWAP && this.itemLocation.inventoryLocation() == InventoryLocationPlayer.getInstance() && arg == this.itemLocation.slot()) {
            return;
        }
        super.m_150399_(slotId, arg, clickType, player);
    }
}

