/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.recipe.ItemStackFromIngredient;

public class RecipeSerializerHelpers {
    public static final StreamCodec<RegistryFriendlyByteBuf, Either<ItemStack, ItemStackFromIngredient>> STREAM_CODEC_ITEMSTACK_OR_TAG = StreamCodec.of(RecipeSerializerHelpers::writeItemStackOrItemStackIngredient, RecipeSerializerHelpers::readItemStackOrItemStackIngredient);
    public static final StreamCodec<RegistryFriendlyByteBuf, Either<Pair<ItemStack, Float>, Pair<ItemStackFromIngredient, Float>>> STREAM_CODEC_ITEMSTACK_OR_ITEMSTACKINGREDIENT_CHANCE = StreamCodec.of(RecipeSerializerHelpers::writeItemStackOrItemStackIngredientChance, RecipeSerializerHelpers::readItemStackOrItemStackIngredientChance);

    public static Codec<ItemStackFromIngredient> getCodecItemStackFromIngredient(Supplier<List<String>> modPriorities) {
        return RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.fieldOf("tag").forGetter(ItemStackFromIngredient::getTag), (App)Codec.INT.optionalFieldOf("count").forGetter(i -> Optional.of(i.getCount()))).apply((Applicative)builder, (arg_0, arg_1) -> RecipeSerializerHelpers.lambda$getCodecItemStackFromIngredient$1((Supplier)modPriorities, arg_0, arg_1)));
    }

    public static Codec<Either<ItemStack, ItemStackFromIngredient>> getCodecItemStackOrTag(Supplier<List<String>> modPriorities) {
        return Codec.either((Codec)ItemStack.CODEC, RecipeSerializerHelpers.getCodecItemStackFromIngredient(modPriorities));
    }

    public static Codec<Either<Pair<ItemStack, Float>, Pair<ItemStackFromIngredient, Float>>> getCodecItemStackOrTagChance(Supplier<List<String>> modPriorities) {
        return Codec.either((Codec)RecordCodecBuilder.create(builder -> builder.group((App)ItemStack.CODEC.fieldOf("item").forGetter(Pair::getLeft), (App)Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(Pair::getRight)).apply((Applicative)builder, Pair::of)), (Codec)RecordCodecBuilder.create(builder -> builder.group((App)RecipeSerializerHelpers.getCodecItemStackFromIngredient(modPriorities).fieldOf("tag").forGetter(Pair::getLeft), (App)Codec.FLOAT.optionalFieldOf("chance", (Object)Float.valueOf(1.0f)).forGetter(Pair::getRight)).apply((Applicative)builder, Pair::of)));
    }

    public static void writeItemStackOrItemStackIngredient(RegistryFriendlyByteBuf buffer, Either<ItemStack, ItemStackFromIngredient> itemStackOrItemStackIngredient) {
        itemStackOrItemStackIngredient.mapBoth(itemStack -> {
            buffer.writeBoolean(true);
            ItemStack.STREAM_CODEC.encode((Object)buffer, itemStack);
            return null;
        }, ingredient -> {
            buffer.writeBoolean(false);
            ingredient.writeToPacket(buffer);
            return null;
        });
    }

    public static Either<ItemStack, ItemStackFromIngredient> readItemStackOrItemStackIngredient(RegistryFriendlyByteBuf buffer) {
        Either outputItem = buffer.readBoolean() ? Either.left((Object)((ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer))) : Either.right((Object)ItemStackFromIngredient.readFromPacket(buffer));
        return outputItem;
    }

    public static void writeItemStackOrItemStackIngredientChance(RegistryFriendlyByteBuf buffer, Either<Pair<ItemStack, Float>, Pair<ItemStackFromIngredient, Float>> itemStackOrItemStackIngredient) {
        itemStackOrItemStackIngredient.mapBoth(itemStack -> {
            buffer.writeBoolean(true);
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)((ItemStack)itemStack.getLeft()));
            buffer.writeFloat(((Float)itemStack.getRight()).floatValue());
            return null;
        }, ingredient -> {
            buffer.writeBoolean(false);
            ((ItemStackFromIngredient)ingredient.getLeft()).writeToPacket(buffer);
            buffer.writeFloat(((Float)ingredient.getRight()).floatValue());
            return null;
        });
    }

    public static Either<Pair<ItemStack, Float>, Pair<ItemStackFromIngredient, Float>> readItemStackOrItemStackIngredientChance(RegistryFriendlyByteBuf buffer) {
        Either outputItem = buffer.readBoolean() ? Either.left((Object)Pair.of((Object)((ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer)), (Object)Float.valueOf(buffer.readFloat()))) : Either.right((Object)Pair.of((Object)ItemStackFromIngredient.readFromPacket(buffer), (Object)Float.valueOf(buffer.readFloat())));
        return outputItem;
    }

    public static <T> void writeOptionalToNetwork(FriendlyByteBuf buffer, Optional<T> value, BiConsumer<FriendlyByteBuf, T> writeToBuffer) {
        value.ifPresentOrElse(v -> {
            buffer.writeBoolean(true);
            writeToBuffer.accept(buffer, v);
        }, () -> buffer.writeBoolean(false));
    }

    public static <T> Optional<T> readOptionalFromNetwork(FriendlyByteBuf buffer, Function<FriendlyByteBuf, T> readFromBuffer) {
        return buffer.readBoolean() ? Optional.of(readFromBuffer.apply(buffer)) : Optional.empty();
    }

    private static /* synthetic */ ItemStackFromIngredient lambda$getCodecItemStackFromIngredient$1(Supplier modPriorities, String tag, Optional count) {
        return new ItemStackFromIngredient((List)modPriorities.get(), tag, Ingredient.fromValues(Stream.of(new Ingredient.TagValue(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)tag))))), count.orElse(1));
    }
}

