/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.ingredient.collection;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientCollectionLike;
import org.cyclops.cyclopscore.ingredient.collection.IngredientSet;

public interface IIngredientMap<T, M, V>
extends IIngredientCollectionLike<T, M, Map.Entry<T, V>> {
    default public boolean containsKey(T instance) {
        return this.get(instance) != null;
    }

    default public boolean containsKey(T instance, M matchCondition) {
        if (Objects.equals(this.getComponent().getMatcher().getAnyMatchCondition(), matchCondition)) {
            return !this.isEmpty();
        }
        return this.iterator(instance, matchCondition).hasNext();
    }

    default public boolean containsKeyAll(Iterable<? extends T> instances) {
        for (T instance : instances) {
            if (this.containsKey(instance)) continue;
            return false;
        }
        return true;
    }

    default public boolean containsKeyAll(Iterable<? extends T> instances, M matchCondition) {
        if (Objects.equals(this.getComponent().getMatcher().getAnyMatchCondition(), matchCondition)) {
            return instances.iterator().hasNext() == !this.isEmpty();
        }
        for (T instance : instances) {
            if (this.containsKey(instance, matchCondition)) continue;
            return false;
        }
        return true;
    }

    public boolean containsValue(V var1);

    default public int countKey(T instance, M matchCondition) {
        if (Objects.equals(this.getComponent().getMatcher().getAnyMatchCondition(), matchCondition)) {
            return this.size();
        }
        return this.keySet(instance, matchCondition).size();
    }

    @Nullable
    public V get(T var1);

    public Collection<V> getAll(T var1, M var2);

    public IngredientSet<T, M> keySet();

    public IngredientSet<T, M> keySet(T var1, M var2);

    public Collection<V> values();

    public Set<Map.Entry<T, V>> entrySet();
}

