/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.neywork;

import com.google.common.collect.Lists;
import io.netty.channel.ChannelHandler;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.Channel;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.SimpleChannel;
import net.minecraftforge.network.simple.SimpleFlow;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.init.ModBaseForge;
import org.cyclops.cyclopscore.network.IPacketHandler;
import org.cyclops.cyclopscore.network.PacketBase;
import org.jetbrains.annotations.Nullable;

@ChannelHandler.Sharable
public final class PacketHandlerForge
implements IPacketHandler {
    private final ModBaseForge<?> mod;
    private final List<Triple<Class<?>, CustomPacketPayload.Type<?>, StreamCodec<? super RegistryFriendlyByteBuf, ? extends PacketBase>>> pendingPacketRegistrations;
    private SimpleChannel networkChannel = null;

    public PacketHandlerForge(ModBaseForge<?> mod) {
        this.mod = mod;
        this.pendingPacketRegistrations = Lists.newArrayList();
    }

    public void init() {
        if (this.networkChannel == null) {
            SimpleFlow<RegistryFriendlyByteBuf, Object> channelBuilder = (SimpleFlow<RegistryFriendlyByteBuf, Object>)ChannelBuilder.named((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)this.mod.getModId(), (String)"channel_main")).clientAcceptedVersions(Channel.VersionTest.exact((int)1)).serverAcceptedVersions(Channel.VersionTest.exact((int)1)).networkProtocolVersion(1).simpleChannel().play().bidirectional();
            for (Triple<Class<?>, CustomPacketPayload.Type<?>, StreamCodec<? super RegistryFriendlyByteBuf, ? extends PacketBase>> triple : this.pendingPacketRegistrations) {
                channelBuilder = this.registerActual(channelBuilder, (Class)triple.getLeft(), (CustomPacketPayload.Type)triple.getMiddle(), (StreamCodec)triple.getRight());
            }
            this.networkChannel = channelBuilder.build();
        }
    }

    protected <P extends PacketBase> SimpleFlow<RegistryFriendlyByteBuf, Object> registerActual(SimpleFlow<RegistryFriendlyByteBuf, Object> channelBuilder, Class<P> clazz, CustomPacketPayload.Type<P> type, StreamCodec<RegistryFriendlyByteBuf, P> codec) {
        return channelBuilder.add(clazz, codec, (packet, ctx) -> {
            if (ctx.isClientSide()) {
                if (packet.isAsync()) {
                    this.handlePacketClient((CustomPayloadEvent.Context)ctx, (PacketBase<?>)packet);
                } else {
                    ctx.enqueueWork(() -> this.handlePacketClient((CustomPayloadEvent.Context)ctx, (PacketBase<?>)packet));
                }
                ctx.setPacketHandled(true);
            } else {
                if (packet.isAsync()) {
                    this.handlePacketServer((CustomPayloadEvent.Context)ctx, (PacketBase<?>)packet);
                } else {
                    ctx.enqueueWork(() -> this.handlePacketServer((CustomPayloadEvent.Context)ctx, (PacketBase<?>)packet));
                }
                ctx.setPacketHandled(true);
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handlePacketClient(CustomPayloadEvent.Context context, PacketBase<?> packet) {
        packet.actionClient(Minecraft.getInstance().player != null ? Minecraft.getInstance().player.level() : null, (Player)Minecraft.getInstance().player);
    }

    public void handlePacketServer(CustomPayloadEvent.Context context, PacketBase<?> packet) {
        packet.actionServer(context.getSender().level(), context.getSender());
    }

    @Override
    public <P extends PacketBase> void register(Class<P> clazz, CustomPacketPayload.Type<P> type, StreamCodec<? super RegistryFriendlyByteBuf, P> codec) {
        this.pendingPacketRegistrations.add(Triple.of(clazz, type, codec));
    }

    @Override
    public void sendToServer(PacketBase packet) {
        this.networkChannel.send((Object)packet, PacketDistributor.SERVER.noArg());
    }

    @Override
    public void sendToPlayer(PacketBase packet, ServerPlayer player) {
        this.networkChannel.send((Object)packet, PacketDistributor.PLAYER.with((Object)player));
    }

    @Override
    public void sendToAllAroundPoint(PacketBase packet, IPacketHandler.TargetPoint point) {
        this.networkChannel.send((Object)packet, PacketDistributor.NEAR.with((Object)new PacketDistributor.TargetPoint(point.excluded(), point.x(), point.y(), point.z(), point.radius(), point.level().dimension())));
    }

    @Override
    public void sendToDimension(PacketBase packet, ServerLevel dimension) {
        this.networkChannel.send((Object)packet, PacketDistributor.DIMENSION.with((Object)dimension.dimension()));
    }

    @Override
    public void sendToAll(PacketBase packet) {
        this.networkChannel.send((Object)packet, PacketDistributor.ALL.noArg());
    }

    @Deprecated
    public record TargetPoint(ServerLevel level, double x, double y, double z, double radius, @Nullable ServerPlayer excluded) {
    }

    @Deprecated
    public static class PacketCodecException
    extends RuntimeException {
        public PacketCodecException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

