/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurabletypeaction;

import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.client.model.IDynamicModelElement;
import org.cyclops.cyclopscore.client.model.IDynamicModelElementCommon;
import org.cyclops.cyclopscore.config.configurabletypeaction.BlockAction;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfigCommon;
import org.cyclops.cyclopscore.helper.ModHelpersForge;
import org.cyclops.cyclopscore.init.ModBaseForge;

public class BlockActionForge<M extends ModBaseForge<M>>
extends BlockAction<M> {
    @Override
    protected void polish(BlockConfigCommon<M> config) {
        super.polish(config);
        if (((ModBaseForge)config.getMod()).getModHelpers().getMinecraftHelpers().isClientSide()) {
            IDynamicModelElementCommon dynamicModelElement;
            if (config.getInstance() instanceof IDynamicModelElement && ((IDynamicModelElement)config.getInstance()).hasDynamicModel()) {
                BlockAction.handleDynamicBlockModel(config);
            }
            if ((dynamicModelElement = config.getBlockClientConfig().getDynamicModelElement()) != null) {
                BlockAction.handleDynamicBlockModel(config);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onModelRegistryLoad(ModelEvent.RegisterAdditional event) {
        for (BlockConfigCommon config : MODEL_ENTRIES) {
            Pair<ModelResourceLocation, ModelResourceLocation> resourceLocations = config.getBlockClientConfig().registerDynamicModel();
            config.getBlockClientConfig().dynamicBlockVariantLocation = (ModelResourceLocation)resourceLocations.getLeft();
            config.getBlockClientConfig().dynamicItemVariantLocation = (ModelResourceLocation)resourceLocations.getRight();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onModelBakeEvent(ModelEvent.ModifyBakingResult event) {
        for (BlockConfigCommon config : MODEL_ENTRIES) {
            BakedModel dynamicModel;
            if (config.getInstance() instanceof IDynamicModelElement) {
                dynamicModelElement = (IDynamicModelElement)config.getInstance();
                dynamicModel = dynamicModelElement.createDynamicModel(event);
            } else {
                dynamicModelElement = config.getBlockClientConfig().getDynamicModelElement();
                dynamicModel = dynamicModelElement.createDynamicModel(pair -> event.getModels().put((ModelResourceLocation)pair.getLeft(), (BakedModel)pair.getRight()));
            }
            if (config.getBlockClientConfig().dynamicBlockVariantLocation != null) {
                event.getModels().put(config.getBlockClientConfig().dynamicBlockVariantLocation, dynamicModel);
            }
            if (config.getBlockClientConfig().dynamicItemVariantLocation == null) continue;
            event.getModels().put(config.getBlockClientConfig().dynamicItemVariantLocation, dynamicModel);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <M extends ModBaseForge> void onRegisterColorHandlers(RegisterColorHandlersEvent.Block event) {
        for (BlockConfigCommon blockConfig : COLOR_ENTRIES) {
            event.register(blockConfig.getBlockClientConfig().getBlockColorHandler(), new Block[]{(Block)blockConfig.getInstance()});
        }
    }

    static {
        if (ModHelpersForge.INSTANCE.getMinecraftHelpers().isClientSide()) {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> BlockActionForge.onModelRegistryLoad(event));
            FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> BlockActionForge.onModelBakeEvent(event));
            FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> BlockActionForge.onRegisterColorHandlers(event));
        }
    }
}

