/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurabletypeaction;

import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.cyclops.cyclopscore.client.model.IDynamicModelElement;
import org.cyclops.cyclopscore.config.configurabletypeaction.ItemAction;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfigCommon;
import org.cyclops.cyclopscore.helper.ModHelpersForge;
import org.cyclops.cyclopscore.init.ModBaseForge;

public class ItemActionForge<M extends ModBaseForge>
extends ItemAction<M> {
    @Override
    protected void polish(ItemConfigCommon<M> config) {
        super.polish(config);
        if (((ModBaseForge)config.getMod()).getModHelpers().getMinecraftHelpers().isClientSide() && config.getInstance() instanceof IDynamicModelElement && ((IDynamicModelElement)config.getInstance()).hasDynamicModel()) {
            ItemAction.handleItemModel(config);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onModelRegistryLoad(ModelEvent.RegisterAdditional event) {
        for (ItemConfigCommon config : MODEL_ENTRIES) {
            config.getItemClientConfig().dynamicItemVariantLocation = config.getItemClientConfig().registerDynamicModel();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onModelBakeEvent(ModelEvent.ModifyBakingResult event) {
        for (ItemConfigCommon config : MODEL_ENTRIES) {
            IDynamicModelElement dynamicModelElement = (IDynamicModelElement)config.getInstance();
            if (config.getItemClientConfig().dynamicItemVariantLocation == null) continue;
            event.getModels().put(config.getItemClientConfig().dynamicItemVariantLocation, dynamicModelElement.createDynamicModel(event));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void onRegisterColorHandlers(RegisterColorHandlersEvent.Item event) {
        for (ItemConfigCommon itemConfig : COLOR_ENTRIES) {
            event.register(itemConfig.getItemClientConfig().getItemColorHandler(), new ItemLike[]{(ItemLike)itemConfig.getInstance()});
        }
    }

    static {
        if (ModHelpersForge.INSTANCE.getMinecraftHelpers().isClientSide()) {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> ItemActionForge.onModelRegistryLoad(event));
            FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> ItemActionForge.onModelBakeEvent(event));
            FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> ItemActionForge.onRegisterColorHandlers(event));
        }
    }
}

