/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.init;

import com.mojang.brigadier.CommandDispatcher;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_10660;
import net.minecraft.class_10665;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_7157;
import org.cyclops.cyclopscore.config.ConfigHandlerFabric;
import org.cyclops.cyclopscore.config.ConfigurableTypesFabric;
import org.cyclops.cyclopscore.events.IRegisterGameTestsEvent;
import org.cyclops.cyclopscore.gametest.GameTestLoaderHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersFabric;
import org.cyclops.cyclopscore.helper.ModBaseCommon;
import org.cyclops.cyclopscore.helper.ModHelpersFabric;
import org.cyclops.cyclopscore.modcompat.ModCompatLoader;
import org.cyclops.cyclopscore.modcompat.forgeconfig.ModCompatForgeConfig;
import org.cyclops.cyclopscore.network.PacketHandlerFabric;
import org.cyclops.cyclopscore.proxy.ICommonProxyCommon;
import org.jetbrains.annotations.Nullable;

public abstract class ModBaseFabric<T extends ModBaseFabric<T>>
extends ModBaseCommon<T>
implements ModInitializer {
    private boolean loaded = false;
    private final ICommonProxyCommon proxy = this.getModHelpers().getMinecraftHelpers().isClientSide() ? this.constructClientProxy() : this.constructCommonProxy();
    private final ConfigHandlerFabric configHandler = this.constructConfigHandler();
    private final PacketHandlerFabric packetHandler = this.constructPacketHandler();

    public ModBaseFabric(String modId, Consumer<T> instanceSetter) {
        super(modId, instanceSetter);
        this.onConfigsRegister(this.getConfigHandler());
        this.getConfigHandler().loadModInit();
        this.loadModCompats(this.getModCompatLoader());
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void onInitialize() {
        this.loaded = true;
        this.getConfigHandler().loadSetup();
        this.getConfigHandler().loadRegistriesCreated();
        this.getConfigHandler().loadRegistriesFilled();
        CommandRegistrationCallback.EVENT.register(this::onRegisterCommands);
        IRegisterGameTestsEvent.EVENT.register(this::registerGameTests);
        ICommonProxyCommon proxy = this.getProxy();
        if (proxy != null) {
            proxy.registerEventHooks();
            proxy.registerTickHandlers();
            if (this.getModHelpers().getMinecraftHelpers().isClientSide()) {
                proxy.registerRenderers();
            }
            proxy.registerPackets(this.getPacketHandler());
        }
    }

    protected ConfigHandlerFabric constructConfigHandler() {
        return new ConfigHandlerFabric(this);
    }

    @Override
    public IModHelpersFabric getModHelpers() {
        return ModHelpersFabric.INSTANCE;
    }

    @Override
    public ICommonProxyCommon getProxy() {
        return this.proxy;
    }

    @Override
    public ConfigHandlerFabric getConfigHandler() {
        return this.configHandler;
    }

    protected PacketHandlerFabric constructPacketHandler() {
        return new PacketHandlerFabric(this);
    }

    @Override
    public PacketHandlerFabric getPacketHandler() {
        return this.packetHandler;
    }

    @Override
    protected void loadModCompats(ModCompatLoader modCompatLoader) {
        super.loadModCompats(modCompatLoader);
        modCompatLoader.addModCompat(new ModCompatForgeConfig());
    }

    protected void onRegisterCommands(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register(this.constructBaseCommand(environment, registryAccess));
    }

    protected void registerGameTests(class_2378<class_10665> testEnvironmentRegistry, BiConsumer<class_2960, class_10660> registrar) {
        GameTestLoaderHelpers.registerCommonTests(this.getModId(), this.getGameTestClasses(), registrar, testEnvironmentRegistry);
    }

    @Nullable
    public static ModBaseFabric get(String modId) {
        return (ModBaseFabric)ModBaseCommon.getCommon(modId);
    }

    public static Map<String, ModBaseFabric<?>> getMods() {
        return ModBaseCommon.getCommonMods();
    }

    static {
        ConfigurableTypesFabric.load();
    }
}

