/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.cyclops.cyclopscore.init.ModBaseFabric;
import org.cyclops.cyclopscore.network.IPacketHandler;
import org.cyclops.cyclopscore.network.PacketBase;

public class PacketHandlerFabric
implements IPacketHandler {
    private final ModBaseFabric<?> mod;

    public PacketHandlerFabric(ModBaseFabric<?> mod) {
        this.mod = mod;
    }

    @Override
    public <P extends PacketBase> void register(Class<P> clazz, class_8710.class_9154<P> type, class_9139<? super class_9129, P> codec) {
        PayloadTypeRegistry.playS2C().register(type, codec);
        if (this.mod.getModHelpers().getMinecraftHelpers().isClientSide()) {
            this.registerClientSide(clazz, type, codec);
        }
        PayloadTypeRegistry.playC2S().register(type, codec);
        ServerPlayNetworking.registerGlobalReceiver(type, (packet, ctx) -> {
            if (packet.isAsync()) {
                this.handlePacketServer(ctx, (PacketBase<?>)packet);
            } else {
                ctx.server().execute(() -> this.handlePacketServer(ctx, (PacketBase<?>)packet));
            }
        });
    }

    public void handlePacketServer(ServerPlayNetworking.Context context, PacketBase<?> packet) {
        packet.actionServer((class_1937)context.player().method_51469(), context.player());
    }

    @Environment(value=EnvType.CLIENT)
    protected <P extends PacketBase> void registerClientSide(Class<P> clazz, class_8710.class_9154<P> type, class_9139<? super class_9129, P> codec) {
        ClientPlayNetworking.registerGlobalReceiver(type, (packet, ctx) -> {
            if (packet.isAsync()) {
                this.handlePacketClient(ctx, (PacketBase<?>)packet);
            } else {
                ctx.client().execute(() -> this.handlePacketClient(ctx, (PacketBase<?>)packet));
            }
        });
    }

    @Environment(value=EnvType.CLIENT)
    public void handlePacketClient(ClientPlayNetworking.Context context, PacketBase<?> packet) {
        packet.actionClient(context.player().method_37908(), (class_1657)context.player());
    }

    @Override
    public void sendToServer(PacketBase packet) {
        ClientPlayNetworking.send((class_8710)packet);
    }

    @Override
    public void sendToPlayer(PacketBase packet, class_3222 player) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
    }

    @Override
    public void sendToAllAroundPoint(PacketBase packet, IPacketHandler.TargetPoint point) {
        for (class_3222 player : PlayerLookup.around((class_3218)point.level(), (class_243)new class_243(point.x(), point.y(), point.z()), (double)point.radius())) {
            if (point.excluded() != null && player == point.excluded()) continue;
            ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
        }
    }

    @Override
    public void sendToDimension(PacketBase packet, class_3218 dimension) {
        for (class_3222 player : dimension.method_18456()) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
        }
    }

    @Override
    public void sendToAll(PacketBase packet) {
        for (class_3222 player : this.mod.getModHelpers().getMinecraftHelpers().getCurrentServer().method_3760().method_14571()) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
        }
    }
}

