/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.persist.nbt;

import com.mojang.datafixers.util.Either;
import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import org.cyclops.cyclopscore.persist.nbt.INBTProvider;
import org.cyclops.cyclopscore.persist.nbt.NBTClassType;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;

public class NBTProviderComponent
implements INBTProvider {
    private final INBTProvider provider;
    private List<Field> nbtPersistedFields = null;

    public NBTProviderComponent(INBTProvider provider) {
        this.provider = provider;
        this.generateNBTPersistedFields();
    }

    private void generateNBTPersistedFields() {
        this.nbtPersistedFields = new LinkedList<Field>();
        for (Class<?> clazz = this.provider.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(NBTPersist.class)) continue;
                this.nbtPersistedFields.add(field);
            }
        }
    }

    private void writePersistedField(Field field, class_11372 output) {
        NBTClassType.performActionForField(this.provider, field, (Either<class_11368, class_11372>)Either.right((Object)output));
    }

    private void readPersistedField(Field field, class_11368 input) {
        NBTClassType.performActionForField(this.provider, field, (Either<class_11368, class_11372>)Either.left((Object)input));
    }

    @Override
    public void writeGeneratedFieldsToNBT(class_11372 output) {
        for (Field field : this.nbtPersistedFields) {
            this.writePersistedField(field, output);
        }
    }

    @Override
    public void readGeneratedFieldsFromNBT(class_11368 input) {
        for (Field field : this.nbtPersistedFields) {
            this.readPersistedField(field, input);
        }
    }
}

