/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.init;

import com.google.common.collect.Lists;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.ConfigHandlerCommon;
import org.cyclops.cyclopscore.config.ConfigHandlerForge;
import org.cyclops.cyclopscore.config.ConfigurableTypesForge;
import org.cyclops.cyclopscore.helper.IModHelpersForge;
import org.cyclops.cyclopscore.helper.ModBaseCommon;
import org.cyclops.cyclopscore.helper.ModHelpersForge;
import org.cyclops.cyclopscore.neywork.PacketHandlerForge;
import org.cyclops.cyclopscore.proxy.ICommonProxyCommon;
import org.jetbrains.annotations.Nullable;

public abstract class ModBaseForge<T extends ModBaseForge<T>>
extends ModBaseCommon<T> {
    private final ICommonProxyCommon proxy;
    private final ConfigHandlerCommon configHandler;
    private final IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
    private final PacketHandlerForge packetHandler;
    private boolean loaded = false;

    public ModBaseForge(String modId, Consumer<T> instanceSetter) {
        super(modId, instanceSetter);
        this.proxy = this.getModHelpers().getMinecraftHelpers().isClientSide() ? this.constructClientProxy() : this.constructCommonProxy();
        this.configHandler = this.constructConfigHandler();
        this.packetHandler = this.constructPacketHandler();
        this.getModEventBus().addListener(this::setup);
        this.getModEventBus().addListener(EventPriority.LOWEST, this::afterRegistriesCreated);
        this.getModEventBus().addListener(EventPriority.HIGHEST, this::beforeRegistriedFilled);
        this.getModEventBus().addListener(this::loadComplete);
        if (this.getModHelpers().getMinecraftHelpers().isClientSide()) {
            this.getModEventBus().addListener(this::setupClient);
        }
        MinecraftForge.EVENT_BUS.addListener(this::onRegisterCommands);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarting);
        this.onConfigsRegister(this.getConfigHandler());
        this.getConfigHandler().initialize(Lists.newArrayList());
        this.getConfigHandler().loadModInit();
        this.loadModCompats(this.getModCompatLoader());
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        this.loaded = true;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    protected ConfigHandlerCommon constructConfigHandler() {
        return new ConfigHandlerForge(this);
    }

    @Override
    public IModHelpersForge getModHelpers() {
        return ModHelpersForge.INSTANCE;
    }

    @Override
    public ICommonProxyCommon getProxy() {
        return this.proxy;
    }

    @Override
    public ConfigHandlerForge getConfigHandler() {
        return (ConfigHandlerForge)this.configHandler;
    }

    public IEventBus getModEventBus() {
        return this.modEventBus;
    }

    protected PacketHandlerForge constructPacketHandler() {
        return new PacketHandlerForge(this);
    }

    @Override
    public PacketHandlerForge getPacketHandlerCommon() {
        return this.packetHandler;
    }

    protected void setup(FMLCommonSetupEvent event) {
        this.log(Level.TRACE, "setup()");
        this.getConfigHandler().loadSetup();
        ICommonProxyCommon proxy = this.getProxy();
        if (proxy != null) {
            proxy.registerEventHooks();
            proxy.registerTickHandlers();
            if (this.getModHelpers().getMinecraftHelpers().isClientSide()) {
                proxy.registerRenderers();
            }
            proxy.registerPackets(this.getPacketHandlerCommon());
            this.getPacketHandlerCommon().init();
        }
    }

    protected void setupClient(FMLClientSetupEvent event) {
        ICommonProxyCommon proxy = this.getProxy();
        if (proxy != null) {
            proxy.registerRenderers();
        }
    }

    private void afterRegistriesCreated(NewRegistryEvent event) {
        this.getConfigHandler().loadForgeRegistries();
    }

    private void beforeRegistriedFilled(RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)ForgeRegistries.SOUND_EVENTS.getRegistryKey())) {
            this.getConfigHandler().loadForgeRegistriesFilled();
        }
    }

    protected void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register(this.constructBaseCommand(event.getCommandSelection(), event.getBuildContext()));
    }

    protected void onServerStarting(ServerStartingEvent event) {
    }

    @Nullable
    public static ModBaseForge get(String modId) {
        return (ModBaseForge)ModBaseCommon.getCommon(modId);
    }

    public static Map<String, ModBaseForge<?>> getMods() {
        return ModBaseCommon.getCommonMods();
    }

    static {
        ConfigurableTypesForge.load();
    }
}

