/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.advancement.criterion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1703;
import net.minecraft.class_2048;
import net.minecraft.class_3222;
import net.minecraft.class_4558;
import net.minecraft.class_5258;
import org.cyclops.cyclopscore.advancement.criterion.ICriterionInstanceTestable;

public class GuiContainerOpenTrigger
extends class_4558<Instance> {
    public static final Codec<Instance> CODEC = RecordCodecBuilder.create(p_311401_ -> p_311401_.group((App)class_2048.field_47250.optionalFieldOf("player").forGetter(Instance::comp_2029), (App)Codec.STRING.optionalFieldOf("container_class").forGetter(Instance::containerClass)).apply((Applicative)p_311401_, Instance::new));

    public Codec<Instance> method_54937() {
        return CODEC;
    }

    public void method_22510(class_3222 pPlayer, Predicate<Instance> pTestTrigger) {
        super.method_22510(pPlayer, pTestTrigger);
    }

    public static final class Instance
    extends Record
    implements class_4558.class_8788,
    ICriterionInstanceTestable<class_1703> {
        private final Optional<class_5258> player;
        private final Optional<String> containerClass;

        public Instance(Optional<class_5258> player, Optional<String> containerClass) {
            this.player = player;
            this.containerClass = containerClass;
        }

        @Override
        public boolean test(class_3222 player, class_1703 container) {
            return this.containerClass.map(className -> {
                Class<?> clazz;
                try {
                    clazz = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Could not find the container class with name '" + className + "'");
                }
                return clazz != null && clazz.isInstance(container);
            }).orElse(true);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Instance.class, "player;containerClass", "player", "containerClass"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Instance.class, "player;containerClass", "player", "containerClass"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Instance.class, "player;containerClass", "player", "containerClass"}, this, o);
        }

        public Optional<class_5258> comp_2029() {
            return this.player;
        }

        public Optional<String> containerClass() {
            return this.containerClass;
        }
    }
}

