/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.component.input;

import java.util.List;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonArrow;
import org.cyclops.cyclopscore.client.gui.component.input.IInputListener;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetTextFieldExtended;

public class WidgetArrowedListField<E>
extends WidgetTextFieldExtended {
    private final boolean arrows;
    private ButtonArrow arrowLeft;
    private ButtonArrow arrowRight;
    private List<E> elements;
    private int activeElement;
    private IInputListener listener;

    public WidgetArrowedListField(class_327 fontrenderer, int x, int y, int width, int height, boolean arrows, class_2561 narrationMessage, boolean background, List<E> elements) {
        super(fontrenderer, x, y, width, height, narrationMessage, background);
        this.arrows = arrows;
        if (this.arrows) {
            this.arrowLeft = new ButtonArrow(x, y - 1, (class_2561)class_2561.method_43471((String)"gui.cyclopscore.left"), button -> this.decrease(), ButtonArrow.Direction.WEST);
            this.arrowRight = new ButtonArrow(x + width, y - 1, (class_2561)class_2561.method_43471((String)"gui.cyclopscore.right"), button -> this.increase(), ButtonArrow.Direction.EAST);
            this.arrowRight.method_46421(this.arrowRight.method_46426() - this.arrowRight.method_25368());
        }
        this.method_1858(true);
        this.elements = elements;
        this.setActiveElement(0);
    }

    @Override
    public void setListener(IInputListener listener) {
        this.listener = listener;
    }

    public boolean method_1851() {
        return false;
    }

    public void setActiveElement(int index) {
        if (index >= this.elements.size()) {
            this.activeElement = -1;
            this.method_1852("");
        } else {
            this.activeElement = index;
            this.method_1852(this.activeElementToString(this.getActiveElement()));
        }
        if (this.listener != null) {
            this.listener.onChanged();
        }
    }

    public boolean setActiveElement(E element) {
        int index = this.elements.indexOf(element);
        if (index < 0) {
            return false;
        }
        this.setActiveElement(index);
        return true;
    }

    protected String activeElementToString(E element) {
        return element.toString();
    }

    public E getActiveElement() throws NumberFormatException {
        if (this.activeElement < 0 || this.activeElement >= this.elements.size()) {
            return null;
        }
        return this.elements.get(this.activeElement);
    }

    @Override
    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int offsetX = 0;
        if (this.arrows) {
            this.arrowLeft.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
            this.arrowRight.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
            offsetX = this.arrowLeft.method_25368();
            this.method_46421(this.method_46426() + offsetX + 1);
            this.field_22758 -= offsetX * 2;
        }
        super.method_48579(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.arrows) {
            this.method_46421(this.method_46426() - (offsetX + 1));
            this.field_22758 += offsetX * 2;
        }
    }

    protected void increase() {
        if (!this.elements.isEmpty()) {
            this.setActiveElement((this.activeElement + 1) % this.elements.size());
        }
    }

    protected void decrease() {
        if (!this.elements.isEmpty()) {
            this.setActiveElement((this.activeElement - 1 + this.elements.size()) % this.elements.size());
        }
    }

    @Override
    public boolean method_25402(class_11909 mouse, boolean isDoubleClick) {
        return this.arrowLeft.method_25402(mouse, isDoubleClick) || this.arrowRight.method_25402(mouse, isDoubleClick) || super.method_25402(mouse, isDoubleClick);
    }
}

