/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.gui.container;

import java.awt.Rectangle;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_1661;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_9848;
import org.cyclops.cyclopscore.client.gui.component.WidgetScrollBar;
import org.cyclops.cyclopscore.client.gui.component.input.WidgetTextFieldExtended;
import org.cyclops.cyclopscore.client.gui.container.ContainerScreenExtended;
import org.cyclops.cyclopscore.inventory.container.ScrollingInventoryContainer;

public abstract class ContainerScreenScrolling<T extends ScrollingInventoryContainer>
extends ContainerScreenExtended<T> {
    private static final int SEARCH_WIDTH = 89;
    private WidgetTextFieldExtended searchField = null;
    private WidgetScrollBar scrollbar = null;

    public ContainerScreenScrolling(T container, class_1661 playerInventory, class_2561 title) {
        super(container, playerInventory, title);
    }

    @Override
    public void method_25426() {
        super.method_25426();
        if (this.isSearchEnabled()) {
            int searchWidth = this.getSearchWidth();
            int searchX = this.getSearchX();
            int searchY = this.getSearchY();
            if (this.searchField == null) {
                Objects.requireNonNull(this.field_22793);
                this.searchField = new WidgetTextFieldExtended(this.field_22793, this.field_2776 + searchX, this.field_2800 + searchY, searchWidth, 9, (class_2561)class_2561.method_43471((String)"gui.cyclopscore.search"));
                this.searchField.method_1880(64);
                this.searchField.method_1880(15);
                this.searchField.method_1858(false);
                this.searchField.method_1862(true);
                this.searchField.method_1868(class_9848.method_61334((int)0xFFFFFF));
                this.searchField.method_1856(true);
                this.searchField.method_1852("");
                this.searchField.method_25358(searchWidth);
                this.searchField.method_46421(this.field_2776 + (searchX + searchWidth) - this.searchField.method_25368());
            } else {
                this.searchField.method_25358(searchWidth);
                this.searchField.method_46421(this.field_2776 + (searchX + searchWidth) - this.searchField.method_25368());
                this.searchField.method_46419(this.field_2800 + searchY);
            }
            this.method_25429((class_364)this.searchField);
        }
        if (this.scrollbar == null) {
            ((ScrollingInventoryContainer)this.method_17577()).updateFilter("");
            this.scrollbar = new WidgetScrollBar(this.field_2776 + this.getScrollX(), this.field_2800 + this.getScrollY(), this.getScrollHeight(), (class_2561)class_2561.method_43471((String)"gui.cyclopscore.scrollbar"), (WidgetScrollBar.IScrollCallback)this.method_17577(), ((ScrollingInventoryContainer)this.method_17577()).getPageSize(), this.getScrollRegion());
            this.scrollbar.setTotalRows(((ScrollingInventoryContainer)this.method_17577()).getFilteredItemCount() / ((ScrollingInventoryContainer)this.method_17577()).getColumns());
        } else {
            this.scrollbar.method_46421(this.field_2776 + this.getScrollX());
            this.scrollbar.method_46419(this.field_2800 + this.getScrollY());
            this.scrollbar.setScollRegion(this.getScrollRegion());
        }
        this.method_25429((class_364)this.scrollbar);
        this.getScrollbar().scrollTo(this.scrollbar.getCurrentScroll());
    }

    protected Rectangle getScrollRegion() {
        return null;
    }

    public boolean method_25400(class_11905 character) {
        if (this.isSearchEnabled() && this.searchField.method_25370()) {
            if (this.searchField.method_25400(character)) {
                this.updateSearch(this.searchField.method_1882());
            }
            return true;
        }
        return super.method_25400(character);
    }

    public boolean method_25404(class_11908 key) {
        if (this.isSearchEnabled() && this.searchField.method_25370() && key.comp_4795() != 256) {
            if (this.searchField.method_25404(key)) {
                this.updateSearch(this.searchField.method_1882());
            }
            return true;
        }
        return super.method_25404(key);
    }

    @Override
    protected void drawCurrentScreen(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        if (this.isSubsetRenderSlots()) {
            class_2371 oldSlots = ((ScrollingInventoryContainer)this.container).field_7761;
            int startIndex = ((ScrollingInventoryContainer)this.method_17577()).getFirstElement();
            class_2371 newSlots = class_2371.method_10211();
            newSlots.addAll((Collection)oldSlots.subList(startIndex, Math.min(oldSlots.size(), startIndex + ((ScrollingInventoryContainer)this.method_17577()).getPageSize() * ((ScrollingInventoryContainer)this.method_17577()).getColumns())));
            newSlots.addAll((Collection)oldSlots.subList(((ScrollingInventoryContainer)this.method_17577()).getUnfilteredItemCount(), oldSlots.size()));
            ((ScrollingInventoryContainer)this.container).field_7761 = newSlots;
            super.drawCurrentScreen(guiGraphics, mouseX, mouseY, partialTicks);
            ((ScrollingInventoryContainer)this.container).field_7761 = oldSlots;
        } else {
            super.drawCurrentScreen(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    protected boolean isSubsetRenderSlots() {
        return false;
    }

    @Override
    protected void method_2389(class_332 guiGraphics, float partialTicks, int mouseX, int mouseY) {
        super.method_2389(guiGraphics, partialTicks, mouseX, mouseY);
        if (this.isSearchEnabled()) {
            this.searchField.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        }
        this.scrollbar.method_48579(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public boolean method_25403(class_11909 event, double mouseX, double mouseY) {
        if (this.method_25399() != null && this.method_25397() && event.method_74245() == 0 && this.method_25399().method_25403(event, mouseX, mouseY)) {
            return true;
        }
        return super.method_25403(event, mouseX, mouseY);
    }

    public boolean method_25401(double mouseX, double mouseY, double mouseZ, double scroll) {
        return this.scrollbar.isMouseOverRegion(mouseX, mouseY) && this.scrollbar.method_25401(mouseX, mouseY, mouseZ, scroll) || super.method_25401(mouseX, mouseY, mouseZ, scroll);
    }

    protected void updateSearch(String searchString) {
        ((ScrollingInventoryContainer)this.method_17577()).updateFilter(searchString);
        this.scrollbar.setTotalRows(((ScrollingInventoryContainer)this.method_17577()).getFilteredItemCount() / ((ScrollingInventoryContainer)this.method_17577()).getColumns());
        this.scrollbar.scrollTo(0.0f);
    }

    public class_342 getSearchField() {
        return this.searchField;
    }

    public WidgetScrollBar getScrollbar() {
        return this.scrollbar;
    }

    protected int getScrollX() {
        return 175;
    }

    protected int getScrollY() {
        return 18;
    }

    protected int getScrollHeight() {
        return 112;
    }

    protected boolean isSearchEnabled() {
        return true;
    }

    protected int getSearchX() {
        return 82;
    }

    protected int getSearchY() {
        return 6;
    }

    protected int getSearchWidth() {
        return 89;
    }
}

