/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_465;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.IGuiHelpers;
import org.cyclops.cyclopscore.helper.IModHelpers;

public class GuiHelpersCommon
implements IGuiHelpers {
    protected final IModHelpers modHelpers;
    private static final List<Pair<Long, String>> COUNT_SCALES = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)1000000000000000000L, (Object)"E"), Pair.of((Object)1000000000000000L, (Object)"P"), Pair.of((Object)1000000000000L, (Object)"T"), Pair.of((Object)1000000000L, (Object)"G"), Pair.of((Object)1000000L, (Object)"M"), Pair.of((Object)1000L, (Object)"K")});

    public GuiHelpersCommon(IModHelpers modHelpers) {
        this.modHelpers = modHelpers;
    }

    @Override
    public int getSlotSize() {
        return 18;
    }

    @Override
    public int getSlotSizeInner() {
        return 16;
    }

    @Override
    public void renderProgressBar(class_332 gui, class_2960 texture, int x, int y, int width, int height, int textureX, int textureY, IGuiHelpers.ProgressDirection direction, int progress, int progressMax) {
        if (progressMax > 0 && progress > 0) {
            int offset;
            int scaledWidth = width;
            int scaledHeight = height;
            if (direction.getIncrementX() != 0) {
                scaledWidth = (int)((double)scaledWidth * ((double)progress / (double)progressMax));
            }
            if (direction.getIncrementY() != 0) {
                scaledHeight = (int)((double)scaledHeight * ((double)progress / (double)progressMax));
            }
            if (direction.getIncrementX() < 0) {
                offset = width - scaledWidth;
                x += offset;
                textureX += offset;
            }
            if (direction.getIncrementY() < 0) {
                offset = height - scaledHeight;
                y += offset;
                textureY += offset;
            }
            gui.method_25290(class_10799.field_56883, texture, x, y, (float)textureX, (float)textureY, scaledWidth, scaledHeight, 256, 256);
        }
    }

    @Override
    public void drawTooltip(class_465 gui, class_332 guiGraphics, List<class_2561> lines, int x, int y) {
        guiGraphics.method_51434(gui.method_64506(), lines, x, y);
    }

    @Override
    public void renderTooltipOptional(class_465 gui, class_332 guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY, Supplier<Optional<List<class_2561>>> linesSupplier) {
        if (this.modHelpers.getRenderHelpers().isPointInRegion(x, y, width, height, mouseX - gui.field_2776, mouseY - gui.field_2800)) {
            linesSupplier.get().ifPresent(lines -> guiGraphics.method_51434(gui.method_64506(), lines, mouseX, mouseY));
        }
    }

    @Override
    public void renderTooltip(class_465 gui, class_332 guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY, Supplier<List<class_2561>> linesSupplier) {
        this.renderTooltipOptional(gui, guiGraphics, x, y, width, height, mouseX, mouseY, () -> Optional.of((List)linesSupplier.get()));
    }

    @Override
    public String quantityToScaledString(long quantity) {
        for (Pair<Long, String> countScale : COUNT_SCALES) {
            long mod;
            long scale = (Long)countScale.getLeft();
            if (quantity < scale) continue;
            long division = quantity / scale;
            Object divisionString = String.valueOf(division);
            if (division < 10L) {
                long mod2 = quantity % scale;
                if (mod2 > 0L) {
                    long digits = mod2 * 100L / scale;
                    divisionString = (String)divisionString + "." + (digits < 10L ? "0" : "") + String.valueOf(digits);
                }
            } else if (division < 100L && (mod = quantity % scale) > 0L) {
                long digits = mod * 10L / scale;
                divisionString = (String)divisionString + "." + String.valueOf(digits);
            }
            return (String)divisionString + (String)countScale.getRight();
        }
        return String.valueOf(quantity);
    }
}

