/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import com.mojang.logging.LogUtils;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_10295;
import net.minecraft.class_10363;
import net.minecraft.class_11352;
import net.minecraft.class_11362;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3797;
import net.minecraft.class_5268;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_8942;
import org.cyclops.cyclopscore.helper.DummyPathElement;
import org.cyclops.cyclopscore.helper.IMinecraftHelpers;
import org.slf4j.Logger;

public abstract class MinecraftHelpersCommon
implements IMinecraftHelpers {
    static final Logger LOGGER = LogUtils.getLogger();

    @Override
    public int getDayLength() {
        return 24000;
    }

    @Override
    public int getComparatorMultiplier() {
        return 15;
    }

    @Override
    public int getSecondInTicks() {
        return 20;
    }

    @Override
    public int getBlockNotify() {
        return 1;
    }

    @Override
    public int getBlockNotifyClient() {
        return 2;
    }

    @Override
    public int getBlockNotifyNoRerender() {
        return 4;
    }

    @Override
    public void setDay(class_3218 world, boolean toDay) {
        int currentTime = (int)world.method_8510();
        int newTime = currentTime - currentTime % (this.getDayLength() / 2) + this.getDayLength() / 2;
        ((class_5268)world.method_8401()).method_29034((long)newTime);
    }

    @Override
    public boolean isPlayerInventoryFull(class_1657 player) {
        return player.method_31548().method_7376() == -1;
    }

    @Override
    public String getMinecraftVersion() {
        return class_3797.field_25319.comp_4025();
    }

    @Override
    public String getMinecraftVersionMajorMinor() {
        return String.join((CharSequence)".", Arrays.asList(this.getMinecraftVersion().split("\\.")).subList(0, 2));
    }

    @Override
    public int compareBlockPos(class_2338 pos1, class_2338 pos2) {
        int compX = Integer.compare(pos1.method_10263(), pos2.method_10263());
        if (compX == 0) {
            int compY = Integer.compare(pos1.method_10264(), pos2.method_10264());
            if (compY == 0) {
                return Integer.compare(pos1.method_10260(), pos2.method_10260());
            }
            return compY;
        }
        return compX;
    }

    @Override
    public class_1799 getRecipeOutput(class_8786<?> recipe, class_1937 level) {
        return this.getRecipeOutput(recipe.comp_1933(), level);
    }

    @Override
    public class_1799 getRecipeOutput(class_1860<?> recipe, class_1937 level) {
        List displays = recipe.method_64664();
        if (displays.isEmpty()) {
            return class_1799.field_8037;
        }
        return ((class_10295)displays.getFirst()).comp_3258().method_64742(class_10363.method_65008((class_1937)level));
    }

    @Override
    public class_2487 valueOutputToNbt(Consumer<class_11372> valueOutputConsumer, @Nullable class_7225.class_7874 lookupProvider) {
        try (class_8942.class_11340 scopedCollector = new class_8942.class_11340((class_8942.class_11336)new DummyPathElement(), LOGGER);){
            class_11362 valueOutput = lookupProvider == null ? class_11362.method_71458((class_8942)scopedCollector) : class_11362.method_71459((class_8942)scopedCollector, (class_7225.class_7874)lookupProvider);
            valueOutputConsumer.accept((class_11372)valueOutput);
            class_2487 class_24872 = valueOutput.method_71475();
            return class_24872;
        }
    }

    @Override
    public <T> T valueInputFromNbt(class_2487 tag, class_7225.class_7874 lookupProvider, Function<class_11368, T> valueInputConsumer) {
        try (class_8942.class_11340 scopedCollector = new class_8942.class_11340((class_8942.class_11336)new DummyPathElement(), LOGGER);){
            class_11368 input = class_11352.method_71417((class_8942)scopedCollector, (class_7225.class_7874)lookupProvider, (class_2487)tag);
            T t = valueInputConsumer.apply(input);
            return t;
        }
    }
}

