/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_11565;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.cyclops.cyclopscore.inventory.INBTInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;

public class SimpleInventory
implements INBTInventory,
class_1278 {
    public static final Codec<SimpleInventory> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("size").forGetter(SimpleInventory::method_5439), (App)Codec.INT.fieldOf("stackLimit").forGetter(SimpleInventory::method_5444), (App)class_1799.field_49266.listOf().fieldOf("contents").forGetter(i -> Arrays.asList(i.getItemStacks()))).apply((Applicative)builder, SimpleInventory::new));
    public static final class_9139<class_9129, SimpleInventory> STREAM_CODEC = class_9139.method_56436((class_9139)class_9135.field_49675, SimpleInventory::method_5439, (class_9139)class_9135.field_49675, SimpleInventory::method_5444, (class_9139)class_1799.field_49268.method_56433(class_9135.method_56363()), i -> Arrays.asList(i.getItemStacks()), SimpleInventory::new);
    protected final class_1799[] contents;
    private final int stackLimit;
    private final List<IDirtyMarkListener> dirtyMarkListeners = Lists.newLinkedList();
    private int hash;

    public SimpleInventory() {
        this(0, 0);
    }

    public SimpleInventory(int size, int stackLimit) {
        this.contents = new class_1799[size];
        for (int i = 0; i < this.contents.length; ++i) {
            this.contents[i] = class_1799.field_8037;
        }
        this.stackLimit = stackLimit;
    }

    public SimpleInventory(int size, int stackLimit, List<class_1799> contents) {
        this.contents = new class_1799[size];
        for (int i = 0; i < this.contents.length; ++i) {
            this.contents[i] = contents.get(i);
        }
        this.stackLimit = stackLimit;
    }

    public synchronized void addDirtyMarkListener(IDirtyMarkListener dirtyMarkListener) {
        this.dirtyMarkListeners.add(dirtyMarkListener);
    }

    public synchronized void removeDirtyMarkListener(IDirtyMarkListener dirtyMarkListener) {
        this.dirtyMarkListeners.remove(dirtyMarkListener);
    }

    public int method_5439() {
        return this.contents.length;
    }

    public class_1799 method_5438(int slotId) {
        return this.contents[slotId];
    }

    public class_1799 method_5434(int slotId, int count) {
        class_1799 stack = this.method_5438(slotId);
        if (slotId < this.method_5439() && !stack.method_7960()) {
            if (stack.method_7947() > count) {
                class_1799 slotContents = stack.method_7972();
                class_1799 result = slotContents.method_7971(count);
                this.method_5447(slotId, slotContents);
                return result;
            }
            this.method_5447(slotId, class_1799.field_8037);
            this.onInventoryChanged();
            return stack;
        }
        return class_1799.field_8037;
    }

    public void method_5447(int slotId, class_1799 itemstack) {
        if (slotId >= this.method_5439()) {
            return;
        }
        this.contents[slotId] = Objects.requireNonNull(itemstack);
        if (!itemstack.method_7960() && itemstack.method_7947() > this.method_5444()) {
            itemstack.method_7939(this.method_5444());
        }
        this.onInventoryChanged();
    }

    public int method_5444() {
        return this.stackLimit;
    }

    protected void onInventoryChanged() {
        this.method_5431();
    }

    public boolean method_5443(class_1657 entityplayer) {
        return true;
    }

    public void method_5435(class_11565 playerIn) {
    }

    public void method_5432(class_11565 playerIn) {
    }

    @Override
    public void read(class_11368 data) {
        this.readFromNBT(data, "items");
    }

    public void readFromNBT(class_11368 data, String tag) {
        class_11368.class_11370 nbttaglist = (class_11368.class_11370)data.method_71436(tag).orElseThrow();
        for (int j = 0; j < this.method_5439(); ++j) {
            this.contents[j] = class_1799.field_8037;
        }
        for (class_11368 slot : nbttaglist) {
            byte index = slot.method_71421("Slot", (byte)0);
            if (index < 0 || index >= this.method_5439()) continue;
            this.contents[index] = slot.method_71426("Item", class_1799.field_49266).orElse(class_1799.field_8037);
        }
    }

    @Override
    public void write(class_11372 data) {
        this.writeToNBT(data, "items");
    }

    public void writeToNBT(class_11372 data, String tag) {
        class_11372.class_11374 slots = data.method_71476(tag);
        for (byte index = 0; index < this.method_5439(); index = (byte)((byte)(index + 1))) {
            class_1799 itemStack = this.method_5438(index);
            if (itemStack.method_7960() || itemStack.method_7947() <= 0) continue;
            class_11372 slot = slots.method_71480();
            slot.method_71462("Slot", index);
            slot.method_71468("Item", class_1799.field_49266, (Object)itemStack);
        }
    }

    public class_1799 method_5441(int slotId) {
        class_1799 stackToTake = this.method_5438(slotId);
        if (stackToTake.method_7960()) {
            return class_1799.field_8037;
        }
        this.method_5447(slotId, class_1799.field_8037);
        return stackToTake;
    }

    public class_1799[] getItemStacks() {
        return this.contents;
    }

    public boolean method_5437(int i, class_1799 itemstack) {
        return i < this.method_5439() && i >= 0;
    }

    public void method_5448() {
        for (int i = 0; i < this.method_5439(); ++i) {
            this.contents[i] = class_1799.field_8037;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void method_5431() {
        LinkedList dirtyMarkListeners;
        ++this.hash;
        SimpleInventory simpleInventory = this;
        synchronized (simpleInventory) {
            dirtyMarkListeners = Lists.newLinkedList(this.dirtyMarkListeners);
        }
        for (IDirtyMarkListener dirtyMarkListener : dirtyMarkListeners) {
            dirtyMarkListener.onDirty();
        }
    }

    @Override
    public boolean method_5442() {
        for (int i = 0; i < this.method_5439(); ++i) {
            if (this.method_5438(i).method_7960()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void toValueOutput(class_11372 tag) {
        this.write(tag);
    }

    @Override
    public void fromValueInput(class_11368 valueInput) {
        this.read(valueInput);
    }

    public int getState() {
        return this.hash;
    }

    public int[] method_5494(class_2350 side) {
        return IntStream.range(0, this.method_5439()).toArray();
    }

    public boolean method_5492(int index, class_1799 itemStackIn, @Nullable class_2350 direction) {
        return true;
    }

    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleInventory)) {
            return false;
        }
        SimpleInventory that = (SimpleInventory)o;
        if (this.stackLimit != that.stackLimit) {
            return false;
        }
        if (this.contents.length != that.contents.length) {
            return false;
        }
        for (int i = 0; i < this.contents.length; ++i) {
            if (class_1799.method_31577((class_1799)this.contents[i], (class_1799)that.contents[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hash;
    }
}

