/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory.container;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.netty.handler.codec.EncoderException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_7225;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.helper.CyclopsCoreInstance;
import org.cyclops.cyclopscore.inventory.IValueNotifiable;
import org.cyclops.cyclopscore.inventory.IValueNotifier;
import org.cyclops.cyclopscore.inventory.container.SyncedGuiVariable;
import org.cyclops.cyclopscore.inventory.container.button.IContainerButtonAction;
import org.cyclops.cyclopscore.inventory.container.button.IContainerButtonClickAcceptorServer;
import org.cyclops.cyclopscore.inventory.slot.SlotArmor;
import org.cyclops.cyclopscore.inventory.slot.SlotExtended;
import org.cyclops.cyclopscore.network.packet.ValueNotifyPacket;

public abstract class ContainerExtended
extends class_1703
implements IContainerButtonClickAcceptorServer<ContainerExtended>,
IValueNotifier,
IValueNotifiable {
    private static final class_1304[] EQUIPMENT_SLOTS = new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166};
    protected static final int ITEMBOX = 18;
    private final Map<String, IContainerButtonAction<ContainerExtended>> buttonActions = Maps.newHashMap();
    private final Map<Integer, class_2487> values = Maps.newHashMap();
    private final List<SyncedGuiVariable<?>> syncedGuiVariables = Lists.newArrayList();
    private int nextValueId = 0;
    private IValueNotifiable guiValueListener = null;
    private class_1661 playerIInventory;
    protected final class_1657 player;
    protected int offsetX = 0;
    protected int offsetY = 0;
    private int quickcraftType = -1;
    private int quickcraftStatus;
    private final Set<class_1735> quickcraftSlots = Sets.newHashSet();

    public ContainerExtended(@Nullable class_3917<?> type, int id, class_1661 inventory) {
        super(type, id);
        this.playerIInventory = inventory;
        this.player = inventory.field_7546;
    }

    @Override
    public class_7225.class_7874 getHolderLookupProvider() {
        return this.player.method_73183().method_30349();
    }

    public void method_7623() {
        super.method_7623();
        if (!this.player.method_73183().method_8608()) {
            for (SyncedGuiVariable<?> syncedGuiVariable : this.syncedGuiVariables) {
                syncedGuiVariable.detectAndSendChanges();
            }
        }
    }

    public void setGuiValueListener(IValueNotifiable listener) {
        this.guiValueListener = listener;
    }

    public void method_7596(class_1712 listener) {
        super.method_7596(listener);
        if (!this.player.method_73183().method_8608()) {
            this.initializeValues();
        }
    }

    protected void initializeValues() {
    }

    protected class_1735 createNewSlot(class_1263 inventory, int index, int x, int y) {
        return new class_1735(inventory, index, x, y);
    }

    public static void setSlotPosX(class_1735 slot, int newValue) {
        slot.field_7873 = newValue;
    }

    public static void setSlotPosY(class_1735 slot, int newValue) {
        slot.field_7872 = newValue;
    }

    protected class_1735 method_7621(class_1735 slot) {
        ContainerExtended.setSlotPosX(slot, slot.field_7873 + this.offsetX);
        ContainerExtended.setSlotPosY(slot, slot.field_7872 + this.offsetY);
        return super.method_7621(slot);
    }

    protected void addInventory(class_1263 inventory, int indexOffset, int offsetX, int offsetY, int rows, int cols) {
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < cols; ++x) {
                this.method_7621(this.createNewSlot(inventory, x + y * cols + indexOffset, offsetX + x * 18, offsetY + y * 18));
            }
        }
    }

    protected void addPlayerInventory(class_1661 inventory, int offsetX, int offsetY) {
        int rows = 3;
        int cols = 9;
        this.addInventory((class_1263)inventory, 0, offsetX, offsetY + 58, 1, cols);
        this.addInventory((class_1263)inventory, cols, offsetX, offsetY, rows, cols);
    }

    protected void addPlayerArmorInventory(class_1661 inventory, int offsetX, int offsetY) {
        for (int k = 0; k < 4; ++k) {
            class_1304 equipmentSlot = EQUIPMENT_SLOTS[k];
            this.method_7621(new SlotArmor((class_1263)inventory, 36 + (3 - k), offsetX, offsetY + k * 18, inventory.field_7546, equipmentSlot));
        }
    }

    protected abstract int getSizeInventory();

    protected int getSlotStart(int originSlot, int slotStart, boolean reverse) {
        return slotStart;
    }

    protected int getSlotRange(int originSlot, int slotRange, boolean reverse) {
        return slotRange;
    }

    public class_1799 method_7601(class_1657 player, int slotID) {
        class_1799 stack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(slotID);
        int slots = this.getSizeInventory();
        if (slot != null && slot.method_7681()) {
            class_1799 stackInSlot = slot.method_7677().method_7972();
            stack = stackInSlot.method_7972();
            if (slotID < slots ? !this.method_7616(stackInSlot, this.getSlotStart(slotID, slots, true), this.getSlotRange(slotID, this.field_7761.size(), true), true) : !this.method_7616(stackInSlot, this.getSlotStart(slotID, 0, false), this.getSlotRange(slotID, slots, false), false)) {
                return class_1799.field_8037;
            }
            if (stackInSlot.method_7947() == 0) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7673(stackInSlot);
            }
            if (stackInSlot.method_7947() == stack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, stackInSlot);
        }
        return stack;
    }

    protected boolean method_7616(class_1799 stack, int slotStart, int slotRange, boolean reverse) {
        class_1799 existingStack;
        class_1735 slot;
        boolean successful = false;
        int slotIndex = slotStart;
        int maxStack = stack.method_7914();
        if (reverse) {
            slotIndex = slotRange - 1;
        }
        if (stack.method_7946()) {
            while (stack.method_7947() > 0 && (!reverse && slotIndex < slotRange || reverse && slotIndex >= slotStart)) {
                slot = (class_1735)this.field_7761.get(slotIndex);
                int maxSlotSize = Math.min(slot.method_7675(), maxStack);
                existingStack = slot.method_7677().method_7972();
                if (slot.method_7680(stack) && !existingStack.method_7960() && class_1799.method_31577((class_1799)stack, (class_1799)existingStack)) {
                    int existingSize = existingStack.method_7947() + stack.method_7947();
                    if (existingSize <= maxSlotSize) {
                        stack.method_7939(0);
                        existingStack.method_7939(existingSize);
                        slot.method_7673(existingStack);
                        successful = true;
                    } else if (existingStack.method_7947() < maxSlotSize) {
                        stack.method_7934(maxSlotSize - existingStack.method_7947());
                        existingStack.method_7939(maxSlotSize);
                        slot.method_7673(existingStack);
                        successful = true;
                    }
                }
                if (reverse) {
                    --slotIndex;
                    continue;
                }
                ++slotIndex;
            }
        }
        if (stack.method_7947() > 0) {
            slotIndex = reverse ? slotRange - 1 : slotStart;
            while (stack.method_7947() > 0 && (!reverse && slotIndex < slotRange || reverse && slotIndex >= slotStart)) {
                slot = (class_1735)this.field_7761.get(slotIndex);
                existingStack = slot.method_7677().method_7972();
                if (slot.method_7680(stack) && existingStack.method_7960()) {
                    int placedAmount = Math.min(stack.method_7947(), slot.method_7675());
                    class_1799 toPut = stack.method_7972();
                    toPut.method_7939(placedAmount);
                    slot.method_7673(toPut);
                    stack.method_7934(placedAmount);
                    successful = true;
                }
                if (reverse) {
                    --slotIndex;
                    continue;
                }
                ++slotIndex;
            }
        }
        return successful;
    }

    public class_1661 getPlayerIInventory() {
        return this.playerIInventory;
    }

    public void method_7593(int slotId, int dragType, class_1713 clickType, class_1657 player) {
        class_1735 slot = slotId < 0 ? null : (class_1735)this.field_7761.get(slotId);
        class_1661 inventory = player.method_31548();
        if (clickType == class_1713.field_7789) {
            int i = this.quickcraftStatus;
            this.quickcraftStatus = ContainerExtended.method_7594((int)dragType);
            if ((i != 1 || this.quickcraftStatus != 2) && i != this.quickcraftStatus) {
                this.method_7605();
            } else if (this.method_34255().method_7960()) {
                this.method_7605();
            } else if (this.quickcraftStatus == 0) {
                this.quickcraftType = ContainerExtended.method_7620((int)dragType);
                if (ContainerExtended.method_7600((int)this.quickcraftType, (class_1657)player)) {
                    this.quickcraftStatus = 1;
                    this.quickcraftSlots.clear();
                } else {
                    this.method_7605();
                }
            } else if (this.quickcraftStatus == 1) {
                class_1799 itemstack = this.method_34255();
                if (ContainerExtended.method_7592((class_1735)slot, (class_1799)itemstack, (boolean)true) && slot.method_7680(itemstack) && (this.quickcraftType == 2 || itemstack.method_7947() > this.quickcraftSlots.size()) && this.method_7615(slot)) {
                    this.quickcraftSlots.add(slot);
                }
            } else if (this.quickcraftStatus == 2) {
                if (!this.quickcraftSlots.isEmpty()) {
                    int phantomCount = 0;
                    if (this.quickcraftSlots.size() == 1) {
                        int l = this.quickcraftSlots.iterator().next().field_7874;
                        this.method_7605();
                        this.method_7593(l, this.quickcraftType, class_1713.field_7790, player);
                        return;
                    }
                    class_1799 itemstack2 = this.method_34255().method_7972();
                    if (itemstack2.method_7960()) {
                        this.method_7605();
                        return;
                    }
                    int k1 = this.method_34255().method_7947();
                    for (class_1735 slot1 : this.quickcraftSlots) {
                        class_1799 itemstack1 = this.method_34255();
                        if (slot1 == null || !ContainerExtended.method_7592((class_1735)slot1, (class_1799)itemstack1, (boolean)true) || !slot1.method_7680(itemstack1) || this.quickcraftType != 2 && itemstack1.method_7947() < this.quickcraftSlots.size() || !this.method_7615(slot1)) continue;
                        int j = slot1.method_7681() ? slot1.method_7677().method_7947() : 0;
                        int k = Math.min(itemstack2.method_7914(), slot1.method_7676(itemstack2));
                        int l = Math.min(ContainerExtended.method_7617(this.quickcraftSlots, (int)this.quickcraftType, (class_1799)itemstack2) + j, k);
                        k1 -= l - j;
                        slot1.method_53512(itemstack2.method_46651(l));
                        if (!(slot1 instanceof SlotExtended) || !((SlotExtended)slot1).isPhantom()) continue;
                        phantomCount += l - j;
                    }
                    itemstack2.method_7939(k1 + phantomCount);
                    this.method_34254(itemstack2);
                }
                this.method_7605();
            } else {
                this.method_7605();
            }
        } else if (this.quickcraftStatus != 0) {
            this.method_7605();
        } else if (slot instanceof SlotExtended && ((SlotExtended)slot).isPhantom()) {
            this.slotClickPhantom(slot, dragType, clickType, player);
        } else {
            super.method_7593(slotId, dragType, clickType, player);
        }
    }

    protected void method_7605() {
        super.method_7605();
        this.quickcraftStatus = 0;
        this.quickcraftSlots.clear();
    }

    private class_1799 slotClickPhantom(class_1735 slot, int mouseButton, class_1713 clickType, class_1657 player) {
        class_1799 stack = class_1799.field_8037;
        if (mouseButton == 2) {
            if (((SlotExtended)slot).isAdjustable()) {
                slot.method_7673(class_1799.field_8037);
            }
        } else if (mouseButton == 0 || mouseButton == 1) {
            slot.method_7668();
            class_1799 stackSlot = slot.method_7677();
            class_1799 stackHeld = this.method_34255();
            if (!stackSlot.method_7960()) {
                stack = stackSlot.method_7972();
            }
            if (stackSlot.method_7960()) {
                if (!stackHeld.method_7960() && slot.method_7680(stackHeld)) {
                    this.fillPhantomSlot(slot, stackHeld, mouseButton, clickType);
                }
            } else if (stackHeld.method_7960()) {
                this.adjustPhantomSlot(slot, mouseButton, clickType);
                slot.method_7667(player, this.method_34255());
            } else if (slot.method_7680(stackHeld)) {
                if (class_1799.method_31577((class_1799)stackSlot, (class_1799)stackHeld)) {
                    this.adjustPhantomSlot(slot, mouseButton, clickType);
                } else {
                    this.fillPhantomSlot(slot, stackHeld, mouseButton, clickType);
                }
            }
        }
        return stack;
    }

    protected void adjustPhantomSlot(class_1735 slot, int mouseButton, class_1713 clickType) {
        int stackSize;
        if (!((SlotExtended)slot).isAdjustable()) {
            return;
        }
        class_1799 stackSlot = slot.method_7677();
        if (clickType == class_1713.field_7794) {
            stackSize = mouseButton == 0 ? (stackSlot.method_7947() + 1) / 2 : stackSlot.method_7947() * 2;
        } else {
            int n = stackSize = mouseButton == 0 ? stackSlot.method_7947() - 1 : stackSlot.method_7947() + 1;
        }
        if (stackSize > slot.method_7675()) {
            stackSize = slot.method_7675();
        }
        stackSlot.method_7939(stackSize);
        if (stackSlot.method_7947() <= 0) {
            slot.method_7673(class_1799.field_8037);
        }
    }

    protected void fillPhantomSlot(class_1735 slot, class_1799 stackHeld, int mouseButton, class_1713 clickType) {
        int stackSize;
        if (!((SlotExtended)slot).isAdjustable()) {
            return;
        }
        int n = stackSize = mouseButton == 0 ? stackHeld.method_7947() : 1;
        if (stackSize > slot.method_7675()) {
            stackSize = slot.method_7675();
        }
        class_1799 phantomStack = stackHeld.method_7972();
        phantomStack.method_7939(stackSize);
        slot.method_7673(phantomStack);
    }

    @Override
    public void putButtonAction(String buttonId, IContainerButtonAction<ContainerExtended> action) {
        this.buttonActions.put(buttonId, action);
    }

    @Override
    public boolean onButtonClick(String buttonId) {
        IContainerButtonAction<ContainerExtended> action = this.buttonActions.get(buttonId);
        if (action != null) {
            action.onAction(buttonId, this);
            return true;
        }
        return false;
    }

    protected int getNextValueId() {
        return this.nextValueId++;
    }

    @Override
    public void setValue(int valueId, class_2487 value) {
        if (!this.values.containsKey(valueId) || !this.values.get(valueId).equals((Object)value)) {
            try {
                if (!this.player.method_73183().method_8608()) {
                    CyclopsCoreInstance.MOD.getPacketHandler().sendToPlayer(new ValueNotifyPacket(this.method_17358(), valueId, value), (class_3222)this.player);
                } else {
                    CyclopsCoreInstance.MOD.getPacketHandler().sendToServer(new ValueNotifyPacket(this.method_17358(), valueId, value));
                }
                this.values.put(valueId, value);
            }
            catch (EncoderException e) {
                CyclopsCoreInstance.MOD.log(Level.WARN, e.getMessage());
            }
        }
    }

    @Override
    public class_2487 getValue(int valueId) {
        return this.values.get(valueId);
    }

    @Override
    public Set<Integer> getValueIds() {
        return this.values.keySet();
    }

    @Override
    public class_3917<?> getValueNotifiableType() {
        return this.method_17358();
    }

    @Override
    public void onUpdate(int valueId, class_2487 value) {
        this.values.put(valueId, value);
        if (this.guiValueListener != null) {
            this.guiValueListener.onUpdate(valueId, value);
        }
    }

    public <T> Supplier<T> registerSyncedVariable(Class<T> clazz, Supplier<T> serverValueSupplier) {
        SyncedGuiVariable<T> variable = new SyncedGuiVariable<T>(this, clazz, serverValueSupplier, (class_7225.class_7874)this.player.method_73183().method_30349());
        this.syncedGuiVariables.add(variable);
        return variable;
    }
}

