/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network.packet;

import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.init.IModBase;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.IPacketHandler;
import org.cyclops.cyclopscore.network.PacketCodec;

public abstract class PlayerPositionPacket<T extends PlayerPositionPacket<T>>
extends PacketCodec<T> {
    private static final int DEFAULT_RANGE = 3000;
    @CodecField
    protected String uuid;
    @CodecField
    protected class_243 position = new class_243(0.0, 0.0, 0.0);
    @CodecField
    private int range = 3000;

    public PlayerPositionPacket(class_8710.class_9154<T> type) {
        super(type);
    }

    public PlayerPositionPacket(class_8710.class_9154<T> type, class_1657 player) {
        this(type, player, 3000);
    }

    public PlayerPositionPacket(class_8710.class_9154<T> type, class_1657 player, int range) {
        super(type);
        this.uuid = player.method_5667().toString();
        this.position = player.method_73189();
        this.range = range;
    }

    @Override
    public boolean isAsync() {
        return false;
    }

    @Override
    public void actionClient(class_1937 level, class_1657 player) {
        if (this.uuid == null) {
            this.getModInstance().log(Level.WARN, "Got PlayerPositionPacket with empty uuid");
            return;
        }
        try {
            UUID uuid = UUID.fromString(this.uuid);
            if (player != null && !player.method_5667().equals(uuid)) {
                player = level.method_18470(uuid);
            }
            if (player == null) {
                this.getModInstance().log(Level.WARN, "Received PlayerPositionPacket for player with uuid '" + String.valueOf(uuid) + "', but player doesn't exist");
            } else {
                this.performClientAction(level, player);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public void actionServer(class_1937 level, class_3222 player) {
        this.getModInstance().getPacketHandler().sendToAllAroundPoint(this.create((class_1657)player, this.range), IPacketHandler.createTargetPointFromEntity((class_1297)player, this.range));
    }

    protected abstract PlayerPositionPacket<?> create(class_1657 var1, int var2);

    protected abstract IModBase getModInstance();

    protected abstract void performClientAction(class_1937 var1, class_1657 var2);
}

