/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network.packet;

import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.cyclops.cyclopscore.helper.CyclopsCoreInstance;
import org.cyclops.cyclopscore.init.IModBase;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.network.packet.PlayerPositionPacket;

public class RingOfFirePacket
extends PlayerPositionPacket<RingOfFirePacket> {
    public static final class_8710.class_9154<RingOfFirePacket> TYPE = new class_8710.class_9154(class_2960.method_60655((String)"cyclopscore", (String)"ring_of_fire"));
    public static final class_9139<class_9129, RingOfFirePacket> CODEC = PacketBase.getCodec(RingOfFirePacket::new);
    private static final double RING_AREA = (double)0.9f;

    public RingOfFirePacket() {
        super(TYPE);
    }

    public RingOfFirePacket(class_1657 player) {
        super(TYPE, player);
    }

    private static void showFireRing(class_1937 world, class_243 pos) {
        double area = 0.9f;
        int points = 40;
        for (double point = (double)(-points); point <= (double)points; point += 1.0) {
            double u = Math.PI * 2 * (point / (double)points);
            double xOffset = Math.cos(u) * area;
            double yOffset = 0.0;
            double zOffset = Math.sin(u) * area;
            double x = pos.field_1352;
            double y = pos.field_1351;
            double z = pos.field_1350;
            double particleX = x + xOffset + (double)(world.field_9229.method_43057() / 5.0f);
            double particleY = y + yOffset + (double)(world.field_9229.method_43057() / 5.0f);
            double particleZ = z + zOffset + (double)(world.field_9229.method_43057() / 5.0f);
            float particleMotionX = (float)xOffset / 50.0f;
            float particleMotionY = 0.01f;
            float particleMotionZ = (float)zOffset / 50.0f;
            if (world.field_9229.method_43048(20) == 0) {
                world.method_8406((class_2394)class_2398.field_11239, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
                continue;
            }
            world.method_8406((class_2394)class_2398.field_11240, particleX, particleY, particleZ, (double)particleMotionX, (double)particleMotionY, (double)particleMotionZ);
        }
    }

    @Override
    protected PlayerPositionPacket<RingOfFirePacket> create(class_1657 player, int range) {
        return new RingOfFirePacket(player);
    }

    @Override
    protected IModBase getModInstance() {
        return CyclopsCoreInstance.MOD;
    }

    @Override
    protected void performClientAction(class_1937 level, class_1657 player) {
        RingOfFirePacket.showFireRing(level, this.position);
    }
}

