/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import java.util.Random;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import org.cyclops.cyclopscore.helper.ILocationHelpers;

public class LocationHelpersCommon
implements ILocationHelpers {
    private static final Random random = new Random();

    @Override
    public class_2338 getRandomPointInSphere(class_2338 center, int radius) {
        class_2338 randomPoint = null;
        while (randomPoint == null) {
            class_2338 coordinates = center.method_10069(-radius + random.nextInt(2 * radius), -radius + random.nextInt(2 * radius), -radius + random.nextInt(2 * radius));
            double totalDistance = center.method_10262((class_2382)coordinates);
            if ((int)Math.sqrt(totalDistance) > radius) continue;
            randomPoint = coordinates;
        }
        return randomPoint;
    }

    @Override
    public class_2338 copyLocation(class_2338 blockPos) {
        return new class_2338(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
    }

    @Override
    public class_2382 copyLocation(class_2382 blockPos) {
        return new class_2382(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
    }

    @Override
    public class_2338 addToDimension(class_2338 blockPos, int dimension, int value) {
        if (dimension == 0) {
            return blockPos.method_10069(value, 0, 0);
        }
        if (dimension == 1) {
            return blockPos.method_10069(0, value, 0);
        }
        if (dimension == 2) {
            return blockPos.method_10069(0, 0, value);
        }
        return blockPos;
    }

    @Override
    public class_2338 fromArray(int[] coordinates) {
        return new class_2338(coordinates[0], coordinates[1], coordinates[2]);
    }

    @Override
    public int[] toArray(class_2382 blockPos) {
        return new int[]{blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()};
    }

    @Override
    public class_2338 subtract(class_2338 blockPos, class_2382 vec) {
        return new class_2338(blockPos.method_10263() - vec.method_10263(), blockPos.method_10264() - vec.method_10264(), blockPos.method_10260() - vec.method_10260());
    }

    @Override
    public class_2382 subtract(class_2382 vec1, class_2382 vec2) {
        return new class_2382(vec1.method_10263() - vec2.method_10263(), vec1.method_10264() - vec2.method_10264(), vec1.method_10260() - vec2.method_10260());
    }

    @Override
    public double getYaw(class_2338 start, class_2338 end) {
        double dX = start.method_10263() - end.method_10263();
        double dY = start.method_10264() - end.method_10264();
        double dZ = start.method_10260() - end.method_10260();
        return Math.atan2(dZ, dX) * 180.0 / Math.PI;
    }

    @Override
    public double getPitch(class_2338 start, class_2338 end) {
        double dX = start.method_10263() - end.method_10263();
        double dY = start.method_10264() - end.method_10264();
        double dZ = start.method_10260() - end.method_10260();
        return (Math.atan2(Math.sqrt(dZ * dZ + dX * dX), dY) + Math.PI) * 180.0 / Math.PI;
    }

    @Override
    public String toCompactString(class_2338 pos) {
        return String.format("x: %s ; y: %s ;z: %s", pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    @Override
    public String toCompactString(class_2382 vec) {
        return String.format("%sx%sx%s", vec.method_10263(), vec.method_10264(), vec.method_10260());
    }
}

