/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.modcompat.forgeconfig;

import fuzs.forgeconfigapiport.fabric.api.neoforge.v4.NeoForgeConfigRegistry;
import fuzs.forgeconfigapiport.fabric.api.neoforge.v4.NeoForgeModConfigEvents;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.ConfigHandlerFabric;
import org.cyclops.cyclopscore.config.ConfigurablePropertyData;
import org.cyclops.cyclopscore.config.ModConfigLocation;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfigCommon;
import org.cyclops.cyclopscore.modcompat.forgeconfig.IConfigInitializer;

public class ConfigHandlerFabricHandler {
    private final ConfigHandlerFabric configHandler;

    public ConfigHandlerFabricHandler(ConfigHandlerFabric configHandler) {
        this.configHandler = configHandler;
    }

    public void onLoad(ModConfig configEvent) {
        this.configHandler.getMod().log(Level.TRACE, "Load config");
        this.syncProcessedConfigs(false);
    }

    public void onReload(ModConfig configEvent) {
        this.configHandler.getMod().log(Level.TRACE, "Reload config");
        this.syncProcessedConfigs(true);
    }

    public void initialize(Collection<IConfigInitializer> configInitializers) {
        NeoForgeModConfigEvents.loading((String)this.configHandler.getMod().getModId()).register(this::onLoad);
        NeoForgeModConfigEvents.reloading((String)this.configHandler.getMod().getModId()).register(this::onReload);
        EnumMap<ModConfig.Type, ModConfigSpec.Builder> configBuilders = new EnumMap<ModConfig.Type, ModConfigSpec.Builder>(ModConfig.Type.class);
        for (ExtendedConfigCommon extendedConfigCommon : this.configHandler.getConfigurables()) {
            ModConfigSpec.Builder configBuilder = (ModConfigSpec.Builder)configBuilders.get(ModConfig.Type.COMMON);
            if (configBuilder == null) {
                configBuilder = new ModConfigSpec.Builder();
                configBuilders.put(ModConfig.Type.COMMON, configBuilder);
            }
            this.configHandler.addCategory(extendedConfigCommon.getConfigurableType().getCategory());
            for (ConfigurablePropertyData<?> configProperty : extendedConfigCommon.configProperties.values()) {
                ModConfigSpec.Builder configBuilderProperty = (ModConfigSpec.Builder)configBuilders.get(ConfigHandlerFabricHandler.modConfigLocationToType(configProperty.getConfigLocation()));
                if (configBuilderProperty == null) {
                    configBuilderProperty = new ModConfigSpec.Builder();
                    configBuilders.put(ConfigHandlerFabricHandler.modConfigLocationToType(configProperty.getConfigLocation()), configBuilderProperty);
                }
                this.configHandler.getCategories().add(configProperty.getCategory());
                this.onConfigPropertyInit(configProperty, configBuilder);
                if (!configProperty.isCommandable()) continue;
                this.configHandler.getCommandableProperties().put(configProperty.getName(), configProperty);
            }
        }
        for (IConfigInitializer iConfigInitializer : configInitializers) {
            iConfigInitializer.initializeConfig(configBuilders);
        }
        for (Map.Entry entry : configBuilders.entrySet()) {
            NeoForgeConfigRegistry.INSTANCE.register(this.configHandler.getMod().getModId(), (ModConfig.Type)entry.getKey(), (IConfigSpec)((ModConfigSpec.Builder)entry.getValue()).build());
        }
    }

    protected <T> void onConfigPropertyInit(ConfigurablePropertyData<T> configPropertyData, ModConfigSpec.Builder configBuilder) {
        configBuilder.push(configPropertyData.category);
        if (configPropertyData.requiresWorldRestart) {
            configBuilder.worldRestart();
        }
        ModConfigSpec.ConfigValue configProperty = configBuilder.comment(configPropertyData.comment).translation(configPropertyData.getLanguageKey()).define(configPropertyData.name, configPropertyData.defaultValue);
        configPropertyData.setConfigProperty((Supplier<Object>)configProperty, newValue -> {
            configProperty.set(newValue);
            configProperty.save();
        });
        configBuilder.pop();
    }

    public void syncProcessedConfigs(boolean reload) {
        for (ExtendedConfigCommon extendedConfigCommon : this.configHandler.getConfigurables()) {
            for (ConfigurablePropertyData<?> configProperty : extendedConfigCommon.configProperties.values()) {
                configProperty.saveToField();
                extendedConfigCommon.onConfigPropertyReload(configProperty, reload);
            }
        }
    }

    public static ModConfig.Type modConfigLocationToType(ModConfigLocation modConfigLocation) {
        switch (modConfigLocation) {
            case COMMON: {
                return ModConfig.Type.COMMON;
            }
            case CLIENT: {
                return ModConfig.Type.CLIENT;
            }
            case SERVER: {
                return ModConfig.Type.SERVER;
            }
            case STARTUP: {
                throw new UnsupportedOperationException("Startup is not supported yet.");
            }
        }
        return null;
    }
}

