/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.configurabletypeaction;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_322;
import net.minecraft.class_7923;
import org.cyclops.cyclopscore.config.configurabletypeaction.ConfigurableTypeActionRegistry;
import org.cyclops.cyclopscore.config.extendedconfig.BlockClientConfig;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfigCommon;
import org.cyclops.cyclopscore.config.extendedconfig.ItemConfigCommon;
import org.cyclops.cyclopscore.init.IModBase;
import org.cyclops.cyclopscore.item.ItemInformationProviderCommon;

public class BlockAction<M extends IModBase>
extends ConfigurableTypeActionRegistry<BlockConfigCommon<M>, class_2248, M> {
    protected static final List<BlockConfigCommon<?>> MODEL_ENTRIES = Lists.newArrayList();
    protected static final List<BlockConfigCommon<?>> COLOR_ENTRIES = Lists.newArrayList();

    public static <M extends IModBase> void register(@Nullable BiFunction<BlockConfigCommon<M>, class_2248, ? extends class_1792> itemBlockConstructor, BlockConfigCommon<M> config, @Nullable Callable<?> callback) {
        BlockAction.register(config, itemBlockConstructor == null ? callback : null);
        if (itemBlockConstructor != null) {
            ItemConfigCommon itemConfig = new ItemConfigCommon(config.getMod(), config.getNamedId(), iConfig -> {
                class_1792 itemBlock = (class_1792)itemBlockConstructor.apply(config, (class_2248)config.getInstance());
                Objects.requireNonNull(itemBlock, "Received a null item for the item block constructor of " + config.getNamedId());
                return itemBlock;
            });
            config.getMod().getConfigHandler().registerToRegistry(class_7923.field_41178, itemConfig, () -> {
                config.setItemInstance((class_1792)itemConfig.getInstance());
                try {
                    if (callback != null) {
                        callback.call();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            });
        }
    }

    @Override
    public void onRegisterForgeFilled(BlockConfigCommon<M> eConfig) {
        BlockAction.register(eConfig.getItemConstructor(), eConfig, () -> {
            eConfig.onForgeRegistered();
            this.polish(eConfig);
            return null;
        });
    }

    public static void handleDynamicBlockModel(BlockConfigCommon extendedConfig) {
        MODEL_ENTRIES.add(extendedConfig);
    }

    protected void polish(BlockConfigCommon<M> config) {
        class_322 blockColorHandler;
        BlockClientConfig<M> clientConfig;
        for (class_1799 itemStack : config.getDefaultCreativeTabEntriesPublic()) {
            config.getMod().registerDefaultCreativeTabEntry(itemStack, class_1761.class_7705.field_40191);
        }
        class_1792 item = config.getItemInstance();
        if (item != null) {
            ItemInformationProviderCommon.registerItem(item);
        }
        if (config.getMod().getModHelpers().getMinecraftHelpers().isClientSide() && (clientConfig = config.getBlockClientConfig()) != null && (blockColorHandler = clientConfig.getBlockColorHandler()) != null) {
            COLOR_ENTRIES.add(config);
        }
    }
}

