/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.helper;

import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import org.apache.commons.lang3.ArrayUtils;
import org.cyclops.cyclopscore.helper.IInventoryHelpers;
import org.cyclops.cyclopscore.helper.IModHelpers;

public class InventoryHelpersCommon
implements IInventoryHelpers {
    private final IModHelpers modHelpers;

    public InventoryHelpersCommon(IModHelpers modHelpers) {
        this.modHelpers = modHelpers;
    }

    @Override
    public void dropItems(class_1937 world, class_1263 inventory, class_2338 blockPos) {
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 itemStack = inventory.method_5438(i);
            if (itemStack.method_7960() || itemStack.method_7947() <= 0) continue;
            this.modHelpers.getItemStackHelpers().spawnItemStack(world, blockPos, inventory.method_5438(i).method_7972());
        }
    }

    @Override
    public void clearInventory(class_1263 inventory) {
        for (int i = 0; i < inventory.method_5439(); ++i) {
            inventory.method_5447(i, class_1799.field_8037);
        }
    }

    @Override
    public void tryReAddToStack(class_1657 player, class_1799 originalStack, class_1799 newStackPart, class_1268 hand) {
        if (!player.method_7337()) {
            if (!originalStack.method_7960() && originalStack.method_7947() == 1) {
                player.method_31548().method_5447(hand == class_1268.field_5808 ? player.method_31548().field_7545 : 40, newStackPart);
            } else {
                if (!originalStack.method_7960()) {
                    originalStack.method_7934(1);
                }
                if (!player.method_31548().method_7394(newStackPart)) {
                    player.method_7328(newStackPart, false);
                }
            }
        }
    }

    @Override
    public void readFromNBT(class_7225.class_7874 provider, class_1263 inventory, class_2487 data, String tagName) {
        int j;
        class_2499 nbttaglist = data.method_10554(tagName, 10);
        for (j = 0; j < inventory.method_5439(); ++j) {
            inventory.method_5447(j, class_1799.field_8037);
        }
        for (j = 0; j < nbttaglist.size(); ++j) {
            class_2487 slot = nbttaglist.method_10602(j);
            int index = slot.method_10545("index") ? slot.method_10550("index") : (int)slot.method_10571("Slot");
            if (index < 0 || index >= inventory.method_5439()) continue;
            inventory.method_5447(index, class_1799.method_57359((class_7225.class_7874)provider, (class_2487)slot));
        }
    }

    @Override
    public void writeToNBT(class_7225.class_7874 provider, class_1263 inventory, class_2487 data, String tagName) {
        class_2499 slots = new class_2499();
        for (int index = 0; index < inventory.method_5439(); index = (int)((byte)(index + 1))) {
            class_1799 itemStack = inventory.method_5438(index);
            if (itemStack.method_7960() || itemStack.method_7947() <= 0) continue;
            class_2487 slot = new class_2487();
            slot.method_10569("index", index);
            slots.add((Object)itemStack.method_57376(provider, (class_2520)slot));
        }
        data.method_10566(tagName, (class_2520)slots);
    }

    @Override
    public boolean addToSlot(class_1263 inventory, int slot, class_1799 itemStack) {
        return this.addToSlot(inventory, slot, itemStack, false);
    }

    @Override
    public class_1799 addToStack(class_1799 itemStack, class_1799 toAdd) {
        if (class_1799.method_31577((class_1799)toAdd, (class_1799)itemStack) && itemStack.method_7947() < itemStack.method_7914()) {
            toAdd = toAdd.method_7972();
            int toAddCount = Math.min(itemStack.method_7914() - itemStack.method_7947(), toAdd.method_7947());
            itemStack.method_7933(toAddCount);
            toAdd.method_7934(toAddCount);
        }
        return toAdd;
    }

    @Override
    public class_1799 fillSlot(class_1263 inventory, int slot, class_1799 itemStack, boolean simulate) {
        class_1799 produceStack = inventory.method_5438(slot);
        if (produceStack.method_7960()) {
            if (!simulate) {
                inventory.method_5447(slot, itemStack);
            }
            return class_1799.field_8037;
        }
        produceStack = produceStack.method_7972();
        class_1799 remainder = this.addToStack(produceStack, itemStack);
        if (!simulate && remainder.method_7947() != itemStack.method_7947()) {
            inventory.method_5447(slot, produceStack);
        }
        return remainder;
    }

    @Override
    public boolean addToSlot(class_1263 inventory, int slot, class_1799 itemStack, boolean simulate) {
        return this.fillSlot(inventory, slot, itemStack, simulate).method_7960();
    }

    @Override
    public class_2371<class_1799> addToInventory(class_1263 inventory, int[] slots, class_2371<class_1799> itemStacks, boolean simulate) {
        class_2371 remaining = class_2371.method_10211();
        for (class_1799 itemStack : itemStacks) {
            for (int i = 0; i < slots.length; ++i) {
                int slot = slots[i];
                itemStack = this.fillSlot(inventory, slot, itemStack, simulate);
                if (simulate) {
                    slots = ArrayUtils.remove((int[])slots, (int)i);
                    --i;
                }
                if (itemStack.method_7960()) break;
            }
            if (itemStack.method_7960()) continue;
            remaining.add((Object)itemStack);
        }
        return remaining;
    }

    @Override
    public void addStackToList(class_2371<class_1799> itemStacks, class_1799 itemStack) {
        boolean added = false;
        class_1799 toAdd = itemStack;
        for (class_1799 existingOutputStack : itemStacks) {
            toAdd = this.addToStack(existingOutputStack, toAdd);
            if (!toAdd.method_7960()) continue;
            added = true;
            break;
        }
        if (!added) {
            itemStacks.add((Object)toAdd.method_7972());
        }
    }
}

