/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.cyclops.cyclopscore.inventory.INBTInventory;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;

public class SimpleInventoryCommon
implements INBTInventory,
class_1278 {
    public static final Codec<SimpleInventoryCommon> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.INT.fieldOf("size").forGetter(SimpleInventoryCommon::method_5439), (App)Codec.INT.fieldOf("stackLimit").forGetter(SimpleInventoryCommon::method_5444), (App)class_1799.field_49266.listOf().fieldOf("contents").forGetter(i -> Arrays.asList(i.getItemStacks()))).apply((Applicative)builder, SimpleInventoryCommon::new));
    public static final class_9139<class_9129, SimpleInventoryCommon> STREAM_CODEC = class_9139.method_56436((class_9139)class_9135.field_49675, SimpleInventoryCommon::method_5439, (class_9139)class_9135.field_49675, SimpleInventoryCommon::method_5444, (class_9139)class_1799.field_49268.method_56433(class_9135.method_56363()), i -> Arrays.asList(i.getItemStacks()), SimpleInventoryCommon::new);
    protected final class_1799[] contents;
    private final int stackLimit;
    private final List<IDirtyMarkListener> dirtyMarkListeners = Lists.newLinkedList();
    private int hash;

    public SimpleInventoryCommon() {
        this(0, 0);
    }

    public SimpleInventoryCommon(int size, int stackLimit) {
        this.contents = new class_1799[size];
        for (int i = 0; i < this.contents.length; ++i) {
            this.contents[i] = class_1799.field_8037;
        }
        this.stackLimit = stackLimit;
    }

    public SimpleInventoryCommon(int size, int stackLimit, List<class_1799> contents) {
        this.contents = new class_1799[size];
        for (int i = 0; i < this.contents.length; ++i) {
            this.contents[i] = contents.get(i);
        }
        this.stackLimit = stackLimit;
    }

    public synchronized void addDirtyMarkListener(IDirtyMarkListener dirtyMarkListener) {
        this.dirtyMarkListeners.add(dirtyMarkListener);
    }

    public synchronized void removeDirtyMarkListener(IDirtyMarkListener dirtyMarkListener) {
        this.dirtyMarkListeners.remove(dirtyMarkListener);
    }

    public int method_5439() {
        return this.contents.length;
    }

    public class_1799 method_5438(int slotId) {
        return this.contents[slotId];
    }

    public class_1799 method_5434(int slotId, int count) {
        class_1799 stack = this.method_5438(slotId);
        if (slotId < this.method_5439() && !stack.method_7960()) {
            if (stack.method_7947() > count) {
                class_1799 slotContents = stack.method_7972();
                class_1799 result = slotContents.method_7971(count);
                this.method_5447(slotId, slotContents);
                return result;
            }
            this.method_5447(slotId, class_1799.field_8037);
            this.onInventoryChanged();
            return stack;
        }
        return class_1799.field_8037;
    }

    public void method_5447(int slotId, class_1799 itemstack) {
        if (slotId >= this.method_5439()) {
            return;
        }
        this.contents[slotId] = Objects.requireNonNull(itemstack);
        if (!itemstack.method_7960() && itemstack.method_7947() > this.method_5444()) {
            itemstack.method_7939(this.method_5444());
        }
        this.onInventoryChanged();
    }

    public int method_5444() {
        return this.stackLimit;
    }

    protected void onInventoryChanged() {
        this.method_5431();
    }

    public boolean method_5443(class_1657 entityplayer) {
        return true;
    }

    public void method_5435(class_1657 playerIn) {
    }

    public void method_5432(class_1657 playerIn) {
    }

    @Override
    public void read(class_7225.class_7874 provider, class_2487 data) {
        this.readFromNBT(provider, data, "items");
    }

    public void readFromNBT(class_7225.class_7874 provider, class_2487 data, String tag) {
        int j;
        class_2499 nbttaglist = data.method_10554(tag, 10);
        for (j = 0; j < this.method_5439(); ++j) {
            this.contents[j] = class_1799.field_8037;
        }
        for (j = 0; j < nbttaglist.size(); ++j) {
            class_2487 slot = nbttaglist.method_10602(j);
            int index = slot.method_10545("index") ? slot.method_10550("index") : (int)slot.method_10571("Slot");
            if (index < 0 || index >= this.method_5439()) continue;
            this.contents[index] = class_1799.method_57359((class_7225.class_7874)provider, (class_2487)slot);
        }
    }

    @Override
    public void write(class_7225.class_7874 provider, class_2487 data) {
        this.writeToNBT(provider, data, "items");
    }

    public void writeToNBT(class_7225.class_7874 provider, class_2487 data, String tag) {
        class_2499 slots = new class_2499();
        for (byte index = 0; index < this.method_5439(); index = (byte)((byte)(index + 1))) {
            class_1799 itemStack = this.method_5438(index);
            if (itemStack.method_7960() || itemStack.method_7947() <= 0) continue;
            class_2487 slot = new class_2487();
            slot.method_10567("Slot", index);
            slots.add((Object)itemStack.method_57376(provider, (class_2520)slot));
        }
        data.method_10566(tag, (class_2520)slots);
    }

    public class_1799 method_5441(int slotId) {
        class_1799 stackToTake = this.method_5438(slotId);
        if (stackToTake.method_7960()) {
            return class_1799.field_8037;
        }
        this.method_5447(slotId, class_1799.field_8037);
        return stackToTake;
    }

    public class_1799[] getItemStacks() {
        return this.contents;
    }

    public boolean method_5437(int i, class_1799 itemstack) {
        return i < this.method_5439() && i >= 0;
    }

    public void method_5448() {
        for (int i = 0; i < this.method_5439(); ++i) {
            this.contents[i] = class_1799.field_8037;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void method_5431() {
        LinkedList dirtyMarkListeners;
        ++this.hash;
        SimpleInventoryCommon simpleInventoryCommon = this;
        synchronized (simpleInventoryCommon) {
            dirtyMarkListeners = Lists.newLinkedList(this.dirtyMarkListeners);
        }
        for (IDirtyMarkListener dirtyMarkListener : dirtyMarkListeners) {
            dirtyMarkListener.onDirty();
        }
    }

    @Override
    public boolean method_5442() {
        for (int i = 0; i < this.method_5439(); ++i) {
            if (this.method_5438(i).method_7960()) continue;
            return false;
        }
        return true;
    }

    @Override
    public class_2487 toNBT(class_7225.class_7874 provider) {
        class_2487 tag = new class_2487();
        this.write(provider, tag);
        return tag;
    }

    @Override
    public void fromNBT(class_7225.class_7874 provider, class_2487 tag) {
        this.read(provider, tag);
    }

    public int getState() {
        return this.hash;
    }

    public int[] method_5494(class_2350 side) {
        return IntStream.range(0, this.method_5439()).toArray();
    }

    public boolean method_5492(int index, class_1799 itemStackIn, @Nullable class_2350 direction) {
        return true;
    }

    public boolean method_5493(int index, class_1799 stack, class_2350 direction) {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleInventoryCommon)) {
            return false;
        }
        SimpleInventoryCommon that = (SimpleInventoryCommon)o;
        if (this.stackLimit != that.stackLimit) {
            return false;
        }
        if (this.contents.length != that.contents.length) {
            return false;
        }
        for (int i = 0; i < this.contents.length; ++i) {
            if (class_1799.method_31577((class_1799)this.contents[i], (class_1799)that.contents[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hash;
    }
}

