/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.network.PacketCodecs;

public abstract class PacketCodec<T extends PacketCodec<T>>
extends PacketBase<T> {
    @Deprecated
    public static final int READ_STRING_MAX_LENGTH = Short.MAX_VALUE;
    protected SingleCache<Void, List<Field>> fieldCache = new SingleCache<Void, List<Field>>(new SingleCache.ICacheUpdater<Void, List<Field>>(){

        @Override
        public List<Field> getNewValue(Void key) {
            LinkedList fieldList = Lists.newLinkedList();
            for (Class<?> clazz = PacketCodec.this.getClass(); clazz != PacketCodec.class && clazz != null; clazz = clazz.getSuperclass()) {
                Field[] fields = clazz.getDeclaredFields();
                Arrays.sort(fields, new Comparator<Field>(this){

                    @Override
                    public int compare(Field o1, Field o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                for (Field field : fields) {
                    if (!field.isAnnotationPresent(CodecField.class)) continue;
                    fieldList.add(field);
                }
            }
            return fieldList;
        }

        @Override
        public boolean isKeyEqual(Void cacheKey, Void newKey) {
            return true;
        }
    });

    public PacketCodec(class_8710.class_9154<T> type) {
        super(type);
    }

    @Deprecated
    public static void addCodedAction(Class<?> clazz, ICodecAction action) {
        PacketCodecs.addCodedAction(clazz, action);
    }

    @Deprecated
    @Nullable
    protected static ICodecAction getActionSuper(Class<?> clazz) {
        return PacketCodecs.getActionSuper(clazz);
    }

    @Deprecated
    public static ICodecAction getAction(Class<?> clazz) {
        return PacketCodecs.getAction(clazz);
    }

    private void loopCodecFields(ICodecRunnable runnable) {
        for (Field field : this.fieldCache.get(null)) {
            Class<?> clazz = field.getType();
            ICodecAction action = PacketCodec.getAction(clazz);
            boolean accessible = field.isAccessible();
            if (!accessible) {
                field.setAccessible(true);
            }
            runnable.run(field, action);
        }
    }

    @Override
    public void encode(class_9129 output) {
        this.loopCodecFields((field, action) -> {
            Object object = null;
            try {
                object = field.get(this);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
            action.encode(object, output);
        });
    }

    @Override
    public void decode(class_9129 input) {
        this.loopCodecFields((field, action) -> {
            Object object = action.decode(input);
            try {
                field.set(this, object);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        });
    }

    @Deprecated
    public static void write(class_9129 packetBuffer, Object object) {
        PacketCodecs.write(packetBuffer, object);
    }

    @Deprecated
    public static <T> T read(class_9129 packetBuffer, Class<T> clazz) {
        return PacketCodecs.read(packetBuffer, clazz);
    }

    public static interface ICodecAction {
        public void encode(Object var1, class_9129 var2);

        public Object decode(class_9129 var1);
    }

    public static interface ICodecRunnable {
        public void run(Field var1, ICodecAction var2);
    }
}

