/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.init;

import com.google.common.collect.Lists;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.config.ConfigHandlerCommon;
import org.cyclops.cyclopscore.config.ConfigHandlerForge;
import org.cyclops.cyclopscore.helper.IModHelpersForge;
import org.cyclops.cyclopscore.helper.ModBaseCommon;
import org.cyclops.cyclopscore.helper.ModHelpersForge;
import org.cyclops.cyclopscore.neywork.PacketHandlerForge;
import org.cyclops.cyclopscore.proxy.ICommonProxyCommon;
import org.jetbrains.annotations.Nullable;

public abstract class ModBaseForge<T extends ModBaseForge<T>>
extends ModBaseCommon<T> {
    private final ICommonProxyCommon proxy;
    private final ConfigHandlerCommon configHandler;
    private final FMLJavaModLoadingContext modLoadingContext;
    private final BusGroup modBusGroup;
    private final PacketHandlerForge packetHandler;
    private boolean loaded = false;

    public ModBaseForge(String modId, Consumer<T> instanceSetter, FMLJavaModLoadingContext context) {
        super(modId, instanceSetter);
        this.modLoadingContext = context;
        this.modBusGroup = context.getModBusGroup();
        this.proxy = this.getModHelpers().getMinecraftHelpers().isClientSide() ? this.constructClientProxy() : this.constructCommonProxy();
        this.configHandler = this.constructConfigHandler();
        this.packetHandler = this.constructPacketHandler();
        FMLCommonSetupEvent.getBus((BusGroup)this.getModBusGroup()).addListener(this::setup);
        NewRegistryEvent.BUS.addListener((byte)-127, this::afterRegistriesCreated);
        RegisterEvent.getBus((BusGroup)this.getModBusGroup()).addListener((byte)127, this::beforeRegistriedFilled);
        FMLLoadCompleteEvent.getBus((BusGroup)this.getModBusGroup()).addListener(this::loadComplete);
        if (this.getModHelpers().getMinecraftHelpers().isClientSide()) {
            FMLClientSetupEvent.getBus((BusGroup)this.getModBusGroup()).addListener(this::setupClient);
        }
        RegisterCommandsEvent.BUS.addListener(this::onRegisterCommands);
        ServerStartingEvent.BUS.addListener(this::onServerStarting);
        this.onConfigsRegister(this.getConfigHandler());
        this.getConfigHandler().initialize(Lists.newArrayList());
        this.getConfigHandler().loadModInit();
        this.loadModCompats(this.getModCompatLoader());
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        this.loaded = true;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    protected ConfigHandlerCommon constructConfigHandler() {
        return new ConfigHandlerForge(this);
    }

    @Override
    public IModHelpersForge getModHelpers() {
        return ModHelpersForge.INSTANCE;
    }

    @Override
    public ICommonProxyCommon getProxy() {
        return this.proxy;
    }

    @Override
    public ConfigHandlerForge getConfigHandler() {
        return (ConfigHandlerForge)this.configHandler;
    }

    public FMLJavaModLoadingContext getModLoadingContext() {
        return this.modLoadingContext;
    }

    public BusGroup getModBusGroup() {
        return this.modBusGroup;
    }

    protected PacketHandlerForge constructPacketHandler() {
        return new PacketHandlerForge(this);
    }

    @Override
    public PacketHandlerForge getPacketHandler() {
        return this.packetHandler;
    }

    protected void setup(FMLCommonSetupEvent event) {
        this.log(Level.TRACE, "setup()");
        this.getConfigHandler().loadSetup();
        ICommonProxyCommon proxy = this.getProxy();
        if (proxy != null) {
            proxy.registerEventHooks();
            proxy.registerTickHandlers();
            if (this.getModHelpers().getMinecraftHelpers().isClientSide()) {
                proxy.registerRenderers();
            }
            proxy.registerPackets(this.getPacketHandler());
            this.getPacketHandler().init();
        }
    }

    protected void setupClient(FMLClientSetupEvent event) {
        ICommonProxyCommon proxy = this.getProxy();
        if (proxy != null) {
            proxy.registerRenderers();
        }
    }

    private void afterRegistriesCreated(NewRegistryEvent event) {
        this.getConfigHandler().loadRegistriesCreated();
    }

    private void beforeRegistriedFilled(RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)ForgeRegistries.SOUND_EVENTS.getRegistryKey())) {
            this.getConfigHandler().loadRegistriesFilled();
        }
    }

    protected void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register(this.constructBaseCommand(event.getCommandSelection(), event.getBuildContext()));
    }

    protected void onServerStarting(ServerStartingEvent event) {
    }

    @Nullable
    public static ModBaseForge get(String modId) {
        return (ModBaseForge)ModBaseCommon.getCommon(modId);
    }

    public static Map<String, ModBaseForge<?>> getMods() {
        return ModBaseCommon.getCommonMods();
    }
}

