---
navigation:
  parent: ae2-mechanics/ae2-mechanics-index.md
  title: Автоматический крафт
  icon: pattern_provider
---

# Автоматический крафт

### Крупная

<GameScene zoom="4" interactive={true}>
  <ImportStructure src="../assets/assemblies/autocraft_setup_greebles.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

Автоматический крафт — одна из основных функций AE2. Вместо того, чтобы вручную создавать нужное количество каждого ингредиента
и трудиться как какой-то *плебей*, вы можете попросить свою МЭ систему сделать это за вас. Или автоматически создавать предметы и экспортировать их куда-нибудь.
Или автоматически поддерживать определенное количество предметов на складе благодаря умному поведению. Это также работает с жидкостями, и, если у вас есть
определенные аддоны для дополнительных типов мод-материалов, таких как газы Mekanism, то и с этими материалами тоже. Это довольно здорово.

Это довольно сложная тема, так что пристегните ремни и вперед!

Настройка автоматического крафта состоит из 3 вещей:
- То, что отправляет запрос на изготовление
- Процессор для изготовления
- <ItemLink id="pattern_provider" />.

Вот что происходит:

1.  Что-то создает запрос на изготовление. Это можете быть вы в терминале, нажав на что-то, что можно создать автоматически,
    или шина экспорта или интерфейс с картой изготовления, запрашивающий один из предметов, которые они настроены экспортировать/запасать.

*   (**ВАЖНО:** используйте то, что вы привязали к "выбору блока" (обычно средняя кнопка мыши), чтобы запрашивать изготовление предметов, которые у вас уже есть в запасе, это может конфликтовать с модами сортировки инвентаря),

2.  MЭ система рассчитывает необходимые ингредиенты и предварительные этапы изготовления для выполнения запроса и сохраняет их в выбранном процессоре изготовления.

3.  <ItemLink id="pattern_provider" /> с соответствующим [шаблоном](../items-blocks-machines/patterns.md) перемещает ингредиенты, указанные в шаблоне, в любой соседний инвентарь.
    В случае рецепта верстака ("шаблон крафта") это будет <ItemLink id="molecular_assembler" />.
    В случае рецепта, не связанного с крафтом ("шаблон обработки"), это будет какой-либо другой блок, машина или сложная установка, управляемая красным камнем.

4.  Результат крафта каким-то образом возвращается в систему, будь то через шину импорта, интерфейс или путем отправки результата обратно в поставщик шаблонов.
**Обратите внимание, что должно произойти событие "вход предмета в систему", вы не можете просто переправить результат в сундук с помощью <ItemLink id="storage_bus" />.**

5.  Если этот крафт является обязательным условием для другого крафта в запросе, предметы хранятся в этом процессоре изготовления, а затем используются в этом крафте.

# Шаблоны

<ItemImage id="crafting_pattern" scale="4" />

Шаблоны создаются в <ItemLink id="pattern_encoding_terminal" /> из пустых шаблонов.

Существует несколько различных видов шаблонов для разных целей:

*   <ItemLink id="crafting_pattern" /> кодируют рецепты, созданные на верстаке. Их можно поместить прямо в <ItemLink id="molecular_assembler" />, чтобы он
    создавал результат при наличии ингредиентов, но в основном они используются в <ItemLink id="pattern_provider" /> рядом с молекулярным сборщиком.
    В этом случае поставщики шаблонов ведут себя особым образом и отправляют соответствующий шаблон вместе с ингредиентами в соседние сборщики.
    Поскольку сборщики автоматически выбрасывают результаты крафта в соседние инвентари, для автоматизации шаблонов крафта достаточно одного сборщика на поставщике шаблонов.


***

*   <ItemLink id="smithing_table_pattern" /> очень похожи на шаблоны крафта, но они кодируют рецепты кузнечного стола. Они также могут быть автоматизированы с помощью поставщика шаблонов
    и молекулярного сборщика и функционируют точно так же. Фактически, шаблоны крафта, кузнечного дела и камнерезания могут
    использоваться в одной и той же установке.


***

*   <ItemLink id="stonecutting_pattern" /> очень похожи на шаблоны крафта, но они кодируют рецепты камнереза. Они также могут быть автоматизированы с помощью поставщика шаблонов
    и молекулярного сборщика и функционируют точно так же. Фактически, шаблоны крафта, кузнечного дела и камнерезания могут
    использоваться в одной и той же установке.

***

*   <ItemLink id="processing_pattern" /> — это то, что обеспечивает большую гибкость в автоматическом крафте. Они являются наиболее обобщенным видом, просто
    говоря: "если поставщик шаблонов помещает эти ингредиенты в соседние инвентари, МЭ система получит эти предметы в ближайшем или отдаленном будущем". 
    Именно с их помощью вы будете автоматически крафтить практически с любой модифицированной машиной, печью и т. п. Поскольку они очень
    универсальны в использовании и не заботятся о том, что происходит между отправкой ингредиентов и получением результата, вы можете делать действительно необычные вещи, например, вводить
    ингредиенты в сложную производственную цепочку фабрики, которая будет сортировать вещи, принимать другие ингредиенты из бесконечно производящих
    ферм, печатать весь сценарий ролика Булджать «Пчелиная война 2 — МЭ системе все равно, пока она получает результат, указанный в шаблоне. Фактически,
    ей даже не важно, имеют ли ингредиенты какое-либо отношение к результату. Вы можете сказать ей "1 доска из вишневого дерева = 1 звезда нижнего мира" и заставить
    свою ферму убивать Иссушителей при получении досок из вишневого дерева, и это будет работать.

Несколько <ItemLink id="pattern_provider" /> с одинаковыми шаблонами поддерживаются и могут работать параллельно. Кроме того, вы можете задать шаблон, например,
8 булыжников = 8 камней вместо 1 булыжника = 1 камень, и поставщик шаблонов будет вставлять 8 булыжников в
вашу установку для плавки при каждой операции, а не по одному за раз.

## Наиболее общая форма "шаблона"

На самом деле существует еще более "общая" форма "шаблона", чем шаблон обработки. <ItemLink id="level_emitter" /> с картой изготовления можно настроить
на излучение сигнала редстоуна для изготовления чего-либо. Этот "шаблон" не определяет и даже не учитывает ингредиенты.
Все, что он говорит: "Если вы излучаете редстоун из этого излучателя уровня, МЭ система получит этот предмет в какой-то момент в
ближайшем или отдаленном будущем". Обычно это используется для активации и деактивации бесконечных ферм, которые не требуют ввода ингредиентов,
или для активации системы, которая обрабатывает рекурсивные рецепты (которые стандартный автокрафт не может понять), например, "1 булыжник = 2 булыжника",
если у вас есть машина, которая дублирует булыжники.


# Процессоры изготовления

<GameScene zoom="4" background="transparent">
  <ImportStructure src="../assets/assemblies/crafting_cpus.snbt" />
  <IsometricCamera yaw="195" pitch="30" />
</GameScene>

Процессоры изготовления управляют запросами/задачами изготовления. Они хранят промежуточные ингредиенты во время выполнения многоэтапных задач изготовления
и влияют на размер задач и, в некоторой степени, на скорость их выполнения. Они представляют собой мультиблочную структуру и
должны иметь форму прямоугольных призм с минимум 1 хранилищем крафта.

Процессоры изготовления состоят из:

*   (Обязательно) [Хранилища для изготовления](../items-blocks-machines/crafting_cpu_multiblock.md), доступные во всех стандартных размерах ячеек (1k, 4k, 16k, 64k, 256k). Они хранят ингредиенты и
    промежуточные ингредиенты, используемые в изготовлении, поэтому для обработки заданий изготовлений с большим количеством ингредиентов процессору требуется больше хранилищ или хранилища большего размера.
*   (Необязательно) <ItemLink id="crafting_accelerator" />, они заставляют систему отправлять больше партий ингредиентов от поставщиков шаблонов.
    Это позволяет, например, поставщику шаблонов, окруженному 6 молекулярными сборщиками, отправлять ингредиенты (и, таким образом, использовать) все 6 сразу, а не только один.
*   (Необязательно) <ItemLink id="crafting_monitor" />, они отображают задание, которое в данный момент обрабатывает ЦП. Их цвет можно изменить с помощью <ItemLink id="color_applicator" />
*   (Необязательно) <ItemLink id="crafting_unit" />, они просто заполняют пространство, чтобы сделать процессоры крафтов прямоугольным параллелепипедом.

Каждый процессор обрабатывает 1 запрос или задание, поэтому, если вы хотите одновременно запросить вычислительный процессор и 256 гладких камней за раз, вам понадобятся 2 мультиблочных структуры процессора.

Их можно настроить для обработки запросов от игроков, автоматизации (шины экспорта и интерфейсов) или и того, и другого.

# Поставщики шаблонов

<Row>
<BlockImage id="pattern_provider" scale="4" />

<BlockImage id="pattern_provider" p:push_direction="up" scale="4" />

<GameScene zoom="4" background="transparent">
  <ImportStructure src="../assets/blocks/cable_pattern_provider.snbt" />
</GameScene>
</Row>

<ItemLink id="pattern_provider" /> являются основным способом взаимодействия вашей системы автоматического крафта с миром. Они перемещают ингредиенты из
своих [шаблонов](../items-blocks-machines/patterns.md) в соседние инвентари, и предметы могут быть вставлены в них, чтобы ввести их в сеть. Часто
канал можно сохранить, направляя вывод машины обратно в ближайший поставщик шаблонов (часто тот, который переместил ингредиенты)
вместо использования <ItemLink id="import_bus" /> для перемещения вывода машины в сеть.

Стоит отметить, что, поскольку они выталкивают ингредиенты непосредственно из [хранилища для изготовления](../items-blocks-machines/crafting_cpu_multiblock.md#crafting-storage) в процессоре изготовления, они
никогда не содержат ингредиенты в своем инвентаре, поэтому вы не можете выводить их из него. Вы должны заставить поставщика выталкивать
их в другой инвентарь (например, в бочку), а затем выводить из него.

Также следует отметить, что поставщик должен отправлять ВСЕ ингредиенты сразу, он не может отправлять половину партии. 

Поставщики шаблонов имеют особое взаимодействие с интерфейсами в [подсетях](../ae2-mechanics/subnetworks.md): если интерфейс не изменен (нет ничего в слотах запроса),
 поставщик полностью пропустит интерфейс и отправит данные непосредственно в [хранилище](../ae2-mechanics/import-export-storage.md) этой подсети,
пропустив интерфейс и не заполняя его партиями рецептов, и, что более важно, не вставляя следующий байт, пока в хранилище не появится место.

Поддерживаются несколько поставщиков шаблонов с идентичными шаблонами, которые работают параллельно.

Поставщики шаблонов будут пытаться распределять свои партии по всем своим интерфейсам, используя таким образом все подключенные машины параллельно.

## Вариативность

Поставщики шаблонов бывают трех различных типов: обычные, направленные и плоские. Это влияет на то, в какую сторону они продвигают
ингредиенты, принимают предметы и обеспечивают сетевое соединение.

*   Обычные поставщики шаблонов передают ингредиенты во все стороны, получают входные данные со всех сторон и, как и большинство машин AE2, действуют
    как кабель, обеспечивающий сетевое соединение со всеми сторонами.

*   Напревленные поставщики шаблонов создаются с помощью <ItemLink id="certus_quartz_wrench" /> на обычном поставщике шаблона для изменения его
направления. Они только передают ингредиенты на выбранную сторону, принимают входные данные со всех сторон и специально не предоставляют сетевое
соединение на выбранной стороне. Это позволяет им передавать данные на машины AE2 без подключения к сетям, если вы хотите создать подсеть.

*   Плоские поставщики шаблонов являются [подразделом кабеля](../ae2-mechanics/cable-subparts.md), поэтому на одном кабеле можно разместить несколько таких поставщиков, что позволяет создавать компактные конфигурации.
    Они действуют аналогично выбранной стороне на направленном поставщике шаблона, предоставляя шаблоны, принимая вводы и не
    предоставляя сетевое соединение на своей поверхности.

Поставщики шаблонов могут переключаться между нормальным и плоским режимом в сетке крафта.

## Настройки

Поставщики шаблонов имеют различные режимы работы:

*   **Режим блокировки** не позволяет поставщику отправлять новую партию ингредиентов, если в машине уже есть
    ингредиенты.
*   **Закрытие крафта** может заблокировать поставщик при различных условиях редстоуна или до тех пор, пока результат
    предыдущего крафта не будет вставлен в этот конкретный шаблон поставщика.
*   Поставщик может отображаться или скрываться на <ItemLink id="pattern_access_terminal" />.

## Приоритет

Приоритеты можно установить, нажав на гаечный ключ в правом верхнем углу графического интерфейса. В случае наличия нескольких [шаблонов](../items-blocks-machines/patterns.md)
для одного и того же предмета, шаблоны в поставщиках с более высоким приоритетом будут использоваться вместо шаблонов в поставщиках с более низким приоритетом,
если только в сети нет ингредиентов для шаблона с более высоким приоритетом.

# Молекулярные сборщики

<BlockImage id="molecular_assembler" scale="4" />

<ItemLink id="molecular_assembler" /> принимает введенные в него предметы и выполняет операцию, определенную соседним <ItemLink id="pattern_provider" />,
или вставленным <ItemLink id="crafting_pattern" />, <ItemLink id="smithing_table_pattern" /> или <ItemLink id="stonecutting_pattern" />,
а затем отправляет результат в соседние инвентари.

Их основное использование — рядом с <ItemLink id="pattern_provider" />. Поставщики шаблонов в этом случае ведут себя особым образом
и отправляют информацию о соответствующем шаблоне вместе с ингредиентами соседним сборщикам. Поскольку сборщики автоматически выбрасывают результаты
крафтов в соседние инвентари (и, таким образом, в слоты возврата поставщика шаблонов), сборщик на поставщике шаблонов
— это все, что нужно для автоматизации шаблонов создания.

<GameScene zoom="4" background="transparent">
<ImportStructure src="../assets/assemblies/assembler_tower.snbt" />
<IsometricCamera yaw="195" pitch="30" />
</GameScene>