---
navigation:
  parent: ae2-mechanics/ae2-mechanics-index.md
  title: Энергия
  icon: energy_cell
---

# Энергия

Ваша сеть требует энергию для её функционированию. У сетей есть резервы энергии, которые [устройства](../ae2-mechanics/devices.md) могут напрямую брать, включая <ItemLink id="vibration_chamber" />, <ItemLink id="energy_acceptor" /> (и <ItemLink id="controller" />). Вы можете посмотреть статистику энергии сети, кликнув ПКМ в любом месте сети с помощью <ItemLink id="network_tool" /> и кликнув ПКМ по контроллеру МЭ сети, если он есть. Это общесетевое хранение и распространение энергии означает, что нет лимитов по скорости передаче энергии, так что устройства могут брать произвольно огромное кол-во энергии и приниматели энергии могут потреблять энергию с функционально неограниченной скоростью, единственное ограничение это ёмкость хранилища энергии.

## Приём энергии

<Row>
  <BlockImage id="energy_acceptor" scale="4" />

  <GameScene zoom="4" background="transparent">
  <ImportStructure src="../assets/blocks/cable_energy_acceptor.snbt" />
  </GameScene>

  <BlockImage id="controller" p:state="online" scale="4" />

  <BlockImage id="vibration_chamber" p:active="true" scale="4" />
</Row>

AE2 не использует Forge Energy (на Forge) или TechReborn Energy (на Fabric) напрямую. Вместо этого, оно конвертирует его в собственную единицу энергии, AE. Эта конвертация одностороняя. Энергия может быть конвертирована с помощью <ItemLink id="energy_acceptor" /> и <ItemLink id="controller" />, хотя грани контроллера лучше для использования для большего количества [каналов](../ae2-mechanics/channels.md). Она также может быть произведена с помощью <ItemLink id="vibration_chamber" />, но AE2 спроектирована для использования в модпаках с другими техническими модами, у которых лучше производство энергии


Всё это означает, что при проектировании инфраструктуру распределения энергии на базе лучше рассматривать сеть AE2 как одну большую многоблочную структуру.

Соотношения конвертации Forge Energy и Techreborn Energy таковы:

*   2 FE = 1 AE (Forge)
*   1 E  = 2 AE (Fabric)

## Хранение энергии

<Row>
  <BlockImage id="energy_cell" scale="4" p:fullness="4" />

  <BlockImage id="dense_energy_cell" scale="4" p:fullness="4" />

  <BlockImage id="creative_energy_cell" scale="4" />
</Row>

По обоснованно очевидных причин, сеть не может принимать или потреблять больше энергии в игровой тик, чем может хранить. Если сеть может хранить только 800 AE, то когда [устройства](../ae2-mechanics/devices.md) потребуют энергию, они смогут использовать только до 800 AE в сеть (предпологая, что хранилище полное) и приниматели энергии смогут поставлять только до 800 AE в сеть (предпологая, что сеть пустая)

Это обычно случается в странных ситуациях, где есть маленькая сеть с всего лишь принимателем энергии, дисководом, терминалом и несколькими устройства и вы пытаетесь перенести инвентарь полный булыжником с инвентарей устройств или иных вещей в сеть. Передача такого количества булыжника за раз за единственный игровой тик требует больше энергии, чем хранится в сети, так что не весь булыжник может быть передан, сеть остаётся без энергии и таким образом, перезагружается

**Это может быть исправлено, если добавить энергохранилища**

Сети имеют встроенные буффер энергии в размере 25 AE на кабель, машину или часть.

<ItemLink id="controller" /> имеют малую ёмкость внутреннего энергохранилища, в размере - 8,000 AE.

<ItemLink id="energy_cell" /> могут хранить 200k AE и всего лишь 1 должно хватить для минимизации отключений из-за высокого разового потребления энергии у обычных сетей. 

<ItemLink id="dense_energy_cell" /> может хранить 1.6M AE, она может понадобится если вам необходимо запустить сеть с сверхвысоким разовым потребление энергии или ради хранения энергии для массивных установок [пространственного хранения](spatial-io.md) с астрономическим разовым потреблением энергии.

<ItemLink id="creative_energy_cell" /> это творческий предмет для тестирования, хранящий ***ВСЮ МОЩЬ ВСЕЛЕННОЙ!*** Ну... или нескончаемую энергию, какая разница. 
