---
navigation:
  parent: ae2-mechanics/ae2-mechanics-index.md
  title: Пространственный ввод/вывод 
  icon: spatial_storage_cell_2
---

# Пространственный ввод/вывод

<GameScene zoom="6" interactive={true}>
  <ImportStructure src="../assets/assemblies/spatial_storage_1x1x1.snbt" />

  <BoxAnnotation color="#33dd33" min="1 1 1" max="2 2 2">
        Объём, который необходимо переместить
  </BoxAnnotation>

  <IsometricCamera yaw="195" pitch="30" />

</GameScene>

Пространственный ввод/вывод это способ вырезать и вставлять физические объёмы пространства в вашем мире. Оно может быть использовано для перемещения <ItemLink id="flawless_budding_quartz" />, создания комнаты, где вы можете менять различный интерьер для использования для разных целей, или даже переместить портал в энд!

Это работает путем *замены* определенного объема на объем идентичного размера в пространственном измерении хранения, отправляя все, что находится
в массиве пилонов, в пространственное измерение хранения, а все, что находится в измерении, — в массив пилонов.

Это означает, что если у вас есть способ путешествовать между измерениями (пространственный ввод-вывод *может* использоваться для создания телепорта,
но это очень сложно, немного нестабильно и выходит за рамки данного руководства), вы можете использовать их как компактные машины нестандартного размера или карманные
измерения.

# Мультиблочная установка

Пространственный ввод-вывод требует определенного расположения своих компонентов для работы и определения объема, который будет вырезан и вставлен.

Все компоненты должны находиться в одной [сети](me-network-connections.md), чтобы функционировать, и в сети может быть только одна
пространственная установка ввода/вывода. Таким образом, рекомендуется использовать [подсеть](subnetworks.md).

## Пространственный порт ввода/вывода

<BlockImage id="spatial_io_port" p:powered="true" scale="4" />

<ItemLink id="spatial_io_port" /> управляет операцией пространственного ввода/вывода. Он отображает статистику по мультиблочной установке и содержит
[пространственные ячейки](../items-blocks-machines/spatial_cells.md)

Оно показывает
- Хранимую и максимальное количество [энергии](energy.md) в сети
- Необходимая энергия для выполнения операции. Может потребоваться достаточно много энергии для выполнения и из-за того, что она используется мгновенно, убедитесь, что у вас есть [энергохранилища](../items-blocks-machines/energy_cells.md).
- Эффективность массива пилонов
- Размер определённого объёма

Чтобы выполнить пространственную операцию ввода/вывода, поместите ячейку пространственного хранения во входной слот и подайте на порт пространственного ввода/вывода импульс редстоуна.
Затем он *поменяет местами* объем в пилонах с объемом в пространственном измерении хранения. Это означает, что если вы отправите некоторый
набор блоков в пространственное измерение хранения, *затем поместите другой набор блоков в пилоны*, верните ячейку в слот ввода
и снова запустите порт ввода-вывода, второй набор блоков исчезнет, а первый набор блоков снова появится.

**БУДЬТЕ ОСТОРОЖНЫ, любое существо в заданном объеме, включая вас, будет унесено, и если у вас нет возможности выбраться, вы окажетесь в ловушке
в пространственном измерении хранения, в темной, безликой коробке.** Используйте это, чтобы подшутить над друзьями!

## Пилоны

<BlockImage id="spatial_pylon" p:powered_on="true" scale="4" />

<ItemLink id="spatial_pylon" /> являются основной частью установки пространственного ввода/вывода и определяют объем, на который будет оказано воздействие.

Объем определяется ограничительной рамкой снаружи пилонов, сокращенной на 1 блок во всех направлениях.

Правила таковы:
- Минимальный размер 3x3x3 (что определяет объем 1x1x1)
- Минимальный размер 3x3x3 (что определяет объем 1x1x1)
- Все пространственные пилоны должны находиться во внешней ограничивающей рамке
- Все пространственные пилоны должны находиться в одной сети.
- Все пилоны должны быть длиной не менее 2 блоков.

Например, предположим, вы хотите определить объем 3x3x3. Согласно правилу 2, все пилоны должны находиться в пределах оболочки 5x5x5 вокруг
объема, который вы хотите определить. Они могут быть расположены практически в любой конфигурации, главное, чтобы они находились в пределах этой оболочки 5x5x5, толщиной 1 блок.

<GameScene zoom="4" interactive={true}>
<ImportStructure src="../assets/assemblies/spatial_storage_3x3x3_pylon_demonstration.snbt" />

<BoxAnnotation color="#33dd33" min="1 1 1" max="4 4 4">
        Объем, который необходимо переместить
  </BoxAnnotation>

<BoxAnnotation color="#3333ff" min="5 5 0" max="0 0 5">
  </BoxAnnotation>

<IsometricCamera yaw="195" pitch="30" />
</GameScene>

Более разумная установка выглядит следующим образом:

<GameScene zoom="4" interactive={true}>
<ImportStructure src="../assets/assemblies/better_spatial_storage_3x3x3.snbt" />

<BoxAnnotation color="#33dd33" min="1 1 1" max="4 4 4">
        Объем, который необходимо переместить
  </BoxAnnotation>

<BoxAnnotation color="#3333ff" min="5 5 0" max="0 0 5">
  </BoxAnnotation>

<IsometricCamera yaw="195" pitch="30" />
</GameScene>

## Эффективность

Эффективность массива пилонов зависит от объема оболочки, которую вы заполняете. Минимальные установки вокруг больших объемов
будут крайне неэффективны и, возможно, потребуют *миллиарды* AE.

## Измерения ячеек и их размеры

После использования [пространственной ячейки](../items-blocks-machines/spatial_cells.md) она получает постоянно заданный набор размеров XYZ (например, 3x4x2)
и связывается с объемом пространства в пространственном измерении хранения. **ВЫ НЕ МОЖЕТЕ СБРОСИТЬ, ПЕРЕФОРМАТИРОВАТЬ ИЛИ ИЗМЕНИТЬ РАЗМЕР ПРОСТРАНСТВЕННОЙ ЯЧЕЙКИ ПОСЛЕ
ЕЕ ИСПОЛЬЗОВАНИЯ.** Создайте новую ячейку, если хотите использовать другие размеры. 

Это не те же размеры, что и в названии ячейки, ячейка 16^3 может иметь любые размеры *до* 16x16x16.

Обратите внимание, что этот объем является направленным и не может быть повернут. Объем 2x2x3 не является таким же, как объем 3x2x2, даже несмотря на то, что они имеют
одинаковый размер.

если размеры XYZ ячейки не соответствуют заданному объему (отображаемому в порту ввода/вывода), порт ввода/вывода не будет работать.